/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.datatypes;

import io.joynr.messaging.datatypes.JoynrErrorCode;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class JoynrErrorCodeMapper {
    private static Map<Integer, JoynrErrorCode> codeToErrorCode = new HashMap<Integer, JoynrErrorCode>();

    public static void storeErrorCodeMapping(JoynrErrorCode errorCode) {
        JoynrErrorCode conflictingErrorCode;
        if (codeToErrorCode.containsKey(errorCode.getCode()) && errorCode != (conflictingErrorCode = codeToErrorCode.get(errorCode.getCode()))) {
            throw new IllegalArgumentException("Error code '" + errorCode.getCode() + ":" + errorCode.toString() + " (" + errorCode.getDescription() + ")' conflicts with error code for '" + conflictingErrorCode.toString() + " (" + errorCode.getDescription() + ")'");
        }
        codeToErrorCode.put(errorCode.getCode(), errorCode);
    }

    public static Optional<JoynrErrorCode> getErrorCode(int code) {
        return Optional.ofNullable(codeToErrorCode.get(code));
    }
}

