/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.runtime;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.joynr.runtime.ShutdownListener;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ShutdownNotifier {
    private static final Logger logger = LoggerFactory.getLogger(ShutdownNotifier.class);
    private static final String PROPERTY_PREPARE_FOR_SHUTDOWN_TIMEOUT = "joynr.runtime.prepareforshutdowntimeout";
    private List<ShutdownListener> shutdownListenerList = new LinkedList<ShutdownListener>();
    @Inject(optional=true)
    @Named(value="joynr.runtime.prepareforshutdowntimeout")
    private int prepareForShutdownTimeoutSec = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForShutdown(ShutdownListener shutdownListener) {
        List<ShutdownListener> list = this.shutdownListenerList;
        synchronized (list) {
            this.shutdownListenerList.add(0, shutdownListener);
            logger.trace("#ShutdownListeners: {}", (Object)this.shutdownListenerList.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerToBeShutdownAsLast(ShutdownListener shutdownListener) {
        List<ShutdownListener> list = this.shutdownListenerList;
        synchronized (list) {
            this.shutdownListenerList.add(shutdownListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareForShutdown() {
        Collection prepareShutdownFutures;
        List<ShutdownListener> list = this.shutdownListenerList;
        synchronized (list) {
            prepareShutdownFutures = this.shutdownListenerList.stream().map(shutdownListener -> CompletableFuture.runAsync(() -> shutdownListener.prepareForShutdown())).collect(Collectors.toList());
        }
        try {
            CompletableFuture.allOf(prepareShutdownFutures.toArray(new CompletableFuture[prepareShutdownFutures.size()])).get(this.prepareForShutdownTimeoutSec, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.error("Exception occurred while preparing shutdown.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        List<ShutdownListener> list = this.shutdownListenerList;
        synchronized (list) {
            this.shutdownListenerList.forEach(shutdownListener -> {
                logger.trace("Shutting down {}", shutdownListener);
                try {
                    shutdownListener.shutdown();
                }
                catch (Exception e) {
                    logger.error("Error shutting down {}:", shutdownListener, (Object)e);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(ShutdownListener shutdownListener) {
        List<ShutdownListener> list = this.shutdownListenerList;
        synchronized (list) {
            this.shutdownListenerList.remove(shutdownListener);
            logger.trace("Removed ShutdownListener, #ShutdownListeners: {}", (Object)this.shutdownListenerList.size());
        }
    }
}

