/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.runtime;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import io.joynr.messaging.NoBackendGlobalAddressFactory;
import io.joynr.messaging.routing.GlobalAddressFactory;
import io.joynr.messaging.routing.TransportReadyListener;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import joynr.system.RoutingTypes.Address;

public class GlobalAddressProvider
implements Provider<Address> {
    public static final String GLOBAL_ADDRESS_FACTORIES = "global_address_factories";
    private Set<GlobalAddressFactory<? extends Address>> addressFactories;
    @Inject(optional=true)
    @Named(value="joynr.messaging.primaryglobaltransport")
    String primaryGlobalTransport;

    @Inject
    public GlobalAddressProvider(@Named(value="global_address_factories") Set<GlobalAddressFactory<? extends Address>> addressFactories) {
        this.addressFactories = addressFactories;
    }

    public void registerGlobalAddressesReadyListener(TransportReadyListener listener) {
        GlobalAddressFactory<? extends Address> addressFactory = this.getPrimaryGlobalAddressFactory();
        addressFactory.registerGlobalAddressReady(listener);
    }

    public GlobalAddressFactory<? extends Address> getAddressFactoryForTransport(String transport) {
        for (GlobalAddressFactory<? extends Address> addressFactory : this.addressFactories) {
            if (!addressFactory.supportsTransport(Optional.ofNullable(transport))) continue;
            return addressFactory;
        }
        return null;
    }

    public GlobalAddressFactory<? extends Address> getAddressFactoryByClass(Class<GlobalAddressFactory<? extends Address>> targetAddressFactoryClass) {
        if (targetAddressFactoryClass == null) {
            return null;
        }
        for (GlobalAddressFactory<? extends Address> addressFactory : this.addressFactories) {
            if (!addressFactory.getClass().isAssignableFrom(targetAddressFactoryClass)) continue;
            return addressFactory;
        }
        return null;
    }

    public Address get() {
        try {
            GlobalAddressFactory<? extends Address> addressFactory = this.getPrimaryGlobalAddressFactory();
            return addressFactory.create();
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    private GlobalAddressFactory<? extends Address> getPrimaryGlobalAddressFactory() {
        GlobalAddressFactory<? extends Address> addressFactory = this.getAddressFactoryForTransport(this.primaryGlobalTransport);
        if (addressFactory == null) {
            if (this.addressFactories.size() == 1) {
                addressFactory = this.addressFactories.iterator().next();
            } else {
                if (this.addressFactories.size() == 0) {
                    throw new IllegalStateException("no global transport was registered");
                }
                this.addressFactories = this.addressFactories.stream().filter(factory -> !NoBackendGlobalAddressFactory.class.isInstance(factory)).collect(Collectors.toSet());
            }
            if (this.addressFactories.size() > 1) {
                throw new IllegalStateException("multiple global transports were registered but joynr.messaging.primaryglobaltransport was not set.");
            }
            addressFactory = this.addressFactories.iterator().next();
        }
        return addressFactory;
    }
}

