/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.util;

import io.joynr.exceptions.JoynrIllegalStateException;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MulticastWildcardRegexFactory {
    private static final Logger logger = LoggerFactory.getLogger(MulticastWildcardRegexFactory.class);

    public Pattern createIdPattern(String multicastId) {
        this.verifyMulticastIdValid(multicastId);
        String patternString = multicastId.replaceAll("^\\+(/)?", "[^\\/]+$1");
        patternString = patternString.replaceAll("/\\+/", "/[^\\/]+/");
        patternString = patternString.replaceAll("(.*)/[\\+]$", "$1/[^\\/]+\\$");
        patternString = patternString.replaceAll("(.*)/[\\*]$", "$1(/.*)?\\$");
        patternString = patternString.replaceAll("^\\*$", ".+");
        logger.trace("Creating multicast ID regex pattern: {}", (Object)patternString);
        return Pattern.compile(patternString);
    }

    private void verifyMulticastIdValid(String multicastId) {
        boolean invalid;
        boolean bl = invalid = multicastId.matches(".*.[^/]\\+.*") || multicastId.matches(".*\\+[^/]+.*") || !"*".equals(multicastId) && multicastId.contains("*") && !multicastId.matches(".*/\\*$");
        if (invalid) {
            throw new JoynrIllegalStateException("Multicast IDs may only contain '+' as a placeholder for a partition, and '*' as only character or right at the end after a '/'. You passed in: " + multicastId);
        }
    }
}

