/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.routing;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.joynr.exceptions.JoynrIllegalStateException;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.messaging.routing.AddressOperation;
import io.joynr.messaging.routing.RoutingEntry;
import io.joynr.messaging.routing.RoutingTable;
import io.joynr.messaging.routing.RoutingTableAddressValidator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.MqttAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RoutingTableImpl
implements RoutingTable {
    private static final Logger logger = LoggerFactory.getLogger(RoutingTableImpl.class);
    private ConcurrentMap<String, RoutingEntry> hashMap = new ConcurrentHashMap<String, RoutingEntry>();
    private final long routingTableGracePeriodMs;
    private final Set<String> knownGbidsSet;
    private String gcdParticipantId;
    private final RoutingTableAddressValidator addressValidator;

    @Inject
    public RoutingTableImpl(@Named(value="joynr.messaging.routingtablegraceperiodms") long routingTableGracePeriodMs, @Named(value="joynr.internal.messaging.gbidArray") String[] gbidsArray, RoutingTableAddressValidator addressValidator) {
        this.routingTableGracePeriodMs = routingTableGracePeriodMs;
        this.knownGbidsSet = new HashSet<String>();
        this.knownGbidsSet.addAll(Arrays.asList(gbidsArray));
        this.gcdParticipantId = "";
        this.addressValidator = addressValidator;
    }

    @Override
    public void setGcdParticipantId(String gcdParticipantId) {
        if (gcdParticipantId == null) {
            throw new JoynrIllegalStateException("The provided gcdParticipantId is null.");
        }
        this.gcdParticipantId = gcdParticipantId;
    }

    @Override
    public Address get(String participantId) {
        return this.getInternal(participantId);
    }

    @Override
    public Address get(String participantId, String gbid) {
        Address address = this.getInternal(participantId);
        if (address != null && this.gcdParticipantId.equals(participantId) && address instanceof MqttAddress) {
            if (!this.knownGbidsSet.contains(gbid)) {
                logger.error("The provided gbid {} for the participantId {} is unknown", (Object)gbid, (Object)participantId);
                address = null;
            } else {
                MqttAddress mqttAddress = new MqttAddress((MqttAddress)address);
                mqttAddress.setBrokerUri(gbid);
                address = mqttAddress;
            }
        }
        return address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Address getInternal(String participantId) {
        RoutingTableImpl routingTableImpl = this;
        synchronized (routingTableImpl) {
            RoutingEntry routingEntry = (RoutingEntry)this.hashMap.get(participantId);
            if (routingEntry == null) {
                logger.warn("No routing table entry found for participantId {}", (Object)participantId);
                return null;
            }
            return routingEntry.getAddress();
        }
    }

    private void updateRoutingEntry(String participantId, RoutingEntry oldRoutingEntry, RoutingEntry newRoutingEntry) {
        this.mergeRoutingEntryAttributes(newRoutingEntry, oldRoutingEntry.getExpiryDateMs(), oldRoutingEntry.getIsSticky());
        this.hashMap.put(participantId, newRoutingEntry);
        logger.debug("Updated routing entry participantId {}, address {}, isGloballyVisible {}, expiryDateMs {}, sticky {} from address {}, isGloballyVisible {}, expiryDateMs {}, sticky {}, refCount {}", new Object[]{participantId, newRoutingEntry.getAddress(), newRoutingEntry.getIsGloballyVisible(), newRoutingEntry.getExpiryDateMs(), newRoutingEntry.getIsSticky(), oldRoutingEntry.getAddress(), oldRoutingEntry.getIsGloballyVisible(), oldRoutingEntry.getExpiryDateMs(), oldRoutingEntry.getIsSticky(), oldRoutingEntry.getRefCount()});
    }

    private void dumpRoutingTable() {
        if (logger.isTraceEnabled()) {
            StringBuilder message = new StringBuilder("Routing table entries:\n");
            for (Map.Entry entry : this.hashMap.entrySet()) {
                message.append("\t> ").append((String)entry.getKey()).append("\t-\t").append(((RoutingEntry)entry.getValue()).getAddress()).append("\t-\t").append(((RoutingEntry)entry.getValue()).getIsGloballyVisible()).append("\t-\t").append(((RoutingEntry)entry.getValue()).getExpiryDateMs()).append("\t-\t").append(((RoutingEntry)entry.getValue()).getIsSticky()).append("\t-\t").append(((RoutingEntry)entry.getValue()).getRefCount()).append("\n");
            }
            logger.trace(message.toString());
        }
    }

    @Override
    public void put(String participantId, Address address, boolean isGloballyVisible, long expiryDateMs) {
        boolean sticky = false;
        this.put(participantId, address, isGloballyVisible, expiryDateMs, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String participantId, Address address, boolean isGloballyVisible, long expiryDateMs, boolean sticky) {
        if (!this.addressValidator.isValidForRoutingTable(address)) {
            logger.trace("ParticipantId {} has an address unsupported within this process.", (Object)participantId);
            return;
        }
        try {
            expiryDateMs = Math.addExact(expiryDateMs, this.routingTableGracePeriodMs);
        }
        catch (ArithmeticException e) {
            expiryDateMs = Long.MAX_VALUE;
        }
        RoutingEntry newRoutingEntry = new RoutingEntry(address, isGloballyVisible, expiryDateMs, sticky);
        RoutingTableImpl routingTableImpl = this;
        synchronized (routingTableImpl) {
            boolean addressOrVisibilityOfRoutingEntryChanged;
            boolean routingEntryAlreadyPresent;
            RoutingEntry oldRoutingEntry = this.hashMap.putIfAbsent(participantId, newRoutingEntry);
            boolean bl = routingEntryAlreadyPresent = oldRoutingEntry != null;
            if (!routingEntryAlreadyPresent) {
                logger.debug("Added routing entry participantId {}, address {}, isGloballyVisible {}, expiryDateMs {}, sticky {}, refCnt {}", new Object[]{participantId, address, isGloballyVisible, expiryDateMs, sticky, 1});
                return;
            }
            oldRoutingEntry.incRefCount();
            newRoutingEntry.setRefCount(oldRoutingEntry.getRefCount());
            logger.debug("Increased reference count for routing entry participantId {}, address {}, new reference count: {}", new Object[]{participantId, oldRoutingEntry.getAddress(), oldRoutingEntry.getRefCount()});
            boolean bl2 = addressOrVisibilityOfRoutingEntryChanged = !address.equals((Object)oldRoutingEntry.getAddress()) || oldRoutingEntry.getIsGloballyVisible() != isGloballyVisible;
            if (addressOrVisibilityOfRoutingEntryChanged) {
                if (oldRoutingEntry.getIsSticky()) {
                    logger.error("Refused to update sticky routing entry participantId {}, address {}, isGloballyVisible {}, to address {}, isGloballyVisible {}, expiryDateMs {}, sticky {}, refCnt {}", new Object[]{participantId, oldRoutingEntry.getAddress(), oldRoutingEntry.getIsGloballyVisible(), address, isGloballyVisible, expiryDateMs, sticky, oldRoutingEntry.getRefCount()});
                } else if (this.addressValidator.allowUpdate(oldRoutingEntry, newRoutingEntry)) {
                    this.updateRoutingEntry(participantId, oldRoutingEntry, newRoutingEntry);
                } else {
                    logger.warn("Refused to update routing entry participantId {}, address {}, isGloballyVisible {}, expiryDateMs {}, sticky {}, to address {}, isGloballyVisible {}, expiryDateMs {}, sticky {}, refCnt {}", new Object[]{participantId, oldRoutingEntry.getAddress(), oldRoutingEntry.getIsGloballyVisible(), oldRoutingEntry.getExpiryDateMs(), oldRoutingEntry.getIsSticky(), address, isGloballyVisible, expiryDateMs, sticky, oldRoutingEntry.getRefCount()});
                }
            } else {
                logger.trace("Updated routing entry participantId {}, address {}, isGloballyVisible {}, expiryDateMs {}, sticky {}, refCnt {} . Updated expiryDate and sticky-flag", new Object[]{participantId, address, isGloballyVisible, expiryDateMs, sticky, oldRoutingEntry.getRefCount()});
                this.mergeRoutingEntryAttributes(oldRoutingEntry, expiryDateMs, sticky);
            }
        }
    }

    private void mergeRoutingEntryAttributes(RoutingEntry entry, long expiryDateMs, boolean isSticky) {
        if (entry.getExpiryDateMs() < expiryDateMs) {
            entry.setExpiryDateMs(expiryDateMs);
        }
        if (isSticky && !entry.getIsSticky()) {
            entry.setIsSticky(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(String participantId) {
        RoutingTableImpl routingTableImpl = this;
        synchronized (routingTableImpl) {
            boolean containsKey = this.hashMap.containsKey(participantId);
            logger.trace("Checking for participant: {} success: {}", (Object)participantId, (Object)containsKey);
            return containsKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getIsGloballyVisible(String participantId) {
        RoutingTableImpl routingTableImpl = this;
        synchronized (routingTableImpl) {
            RoutingEntry routingEntry = (RoutingEntry)this.hashMap.get(participantId);
            if (routingEntry == null) {
                throw new JoynrRuntimeException("participantId doesn't exist in the routing table");
            }
            return routingEntry.getIsGloballyVisible();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getExpiryDateMs(String participantId) {
        RoutingTableImpl routingTableImpl = this;
        synchronized (routingTableImpl) {
            RoutingEntry routingEntry = (RoutingEntry)this.hashMap.get(participantId);
            if (routingEntry == null) {
                throw new JoynrRuntimeException("participantId doesn't exist in the routing table");
            }
            return routingEntry.getExpiryDateMs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getIsSticky(String participantId) {
        RoutingTableImpl routingTableImpl = this;
        synchronized (routingTableImpl) {
            RoutingEntry routingEntry = (RoutingEntry)this.hashMap.get(participantId);
            if (routingEntry == null) {
                throw new JoynrRuntimeException("participantId doesn't exist in the routing table");
            }
            return routingEntry.getIsSticky();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String participantId) {
        RoutingTableImpl routingTableImpl = this;
        synchronized (routingTableImpl) {
            RoutingEntry routingEntry = (RoutingEntry)this.hashMap.get(participantId);
            if (routingEntry != null) {
                if (routingEntry.isSticky) {
                    logger.warn("Cannot remove sticky routing entry (participantId={}, address={}, isGloballyVisible={}, expiryDateMs={}, sticky={}, refCnt={})", new Object[]{participantId, routingEntry.getAddress(), routingEntry.getIsGloballyVisible(), routingEntry.getExpiryDateMs(), routingEntry.getIsSticky(), routingEntry.getRefCount()});
                } else {
                    routingEntry.decRefCount();
                    logger.debug("Decreased reference count for routing entry participantId {}, address {}, isGloballyVisible {}, expiryDateMs {}, sticky {}, new reference count: {}", new Object[]{participantId, routingEntry.getAddress(), routingEntry.getIsGloballyVisible(), routingEntry.getExpiryDateMs(), routingEntry.getIsSticky(), routingEntry.getRefCount()});
                    if (routingEntry.getRefCount() > 0L) {
                        return;
                    }
                    this.hashMap.remove(participantId);
                    logger.debug("Removed routing entry participantId {}, address {}, isGloballyVisible {}, expiryDateMs {}, sticky {}", new Object[]{participantId, routingEntry.getAddress(), routingEntry.getIsGloballyVisible(), routingEntry.getExpiryDateMs(), routingEntry.getIsSticky()});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(AddressOperation addressOperation) {
        RoutingTableImpl routingTableImpl = this;
        synchronized (routingTableImpl) {
            if (addressOperation == null) {
                throw new IllegalArgumentException();
            }
            for (RoutingEntry routingEntry : this.hashMap.values()) {
                addressOperation.perform(routingEntry.getAddress());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purge() {
        RoutingTableImpl routingTableImpl = this;
        synchronized (routingTableImpl) {
            Iterator it = this.hashMap.entrySet().iterator();
            long currentTimeMillis = System.currentTimeMillis();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                logger.trace("Check: participantId {}, sticky {}, expiryDateMs {}, refCnt {}", new Object[]{e.getKey(), ((RoutingEntry)e.getValue()).getIsSticky(), ((RoutingEntry)e.getValue()).getExpiryDateMs(), ((RoutingEntry)e.getValue()).getRefCount()});
                if (((RoutingEntry)e.getValue()).getIsSticky() || ((RoutingEntry)e.getValue()).expiryDateMs >= currentTimeMillis) continue;
                it.remove();
                logger.trace("Purged routing entry participantId {}, address {}, isGloballyVisible {}, expiryDateMs {}, sticky {}, refCnt {}", new Object[]{e.getKey(), ((RoutingEntry)e.getValue()).getAddress(), ((RoutingEntry)e.getValue()).getIsGloballyVisible(), ((RoutingEntry)e.getValue()).getExpiryDateMs(), ((RoutingEntry)e.getValue()).getIsSticky(), ((RoutingEntry)e.getValue()).getRefCount()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementReferenceCount(String participantId) {
        RoutingTableImpl routingTableImpl = this;
        synchronized (routingTableImpl) {
            RoutingEntry routingEntry = (RoutingEntry)this.hashMap.get(participantId);
            if (routingEntry == null) {
                throw new JoynrIllegalStateException("No routing entry with participantId " + participantId + "found!");
            }
            routingEntry.incRefCount();
            logger.debug("Increased reference count for routing entry participantId {}, new reference count: {}", (Object)participantId, (Object)routingEntry.getRefCount());
        }
    }
}

