/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.routing;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.exceptions.JoynrDelayMessageException;
import io.joynr.exceptions.JoynrIllegalStateException;
import io.joynr.exceptions.JoynrMessageExpiredException;
import io.joynr.exceptions.JoynrMessageNotSentException;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.exceptions.JoynrShutdownException;
import io.joynr.messaging.FailureAction;
import io.joynr.messaging.IMessagingMulticastSubscriber;
import io.joynr.messaging.IMessagingSkeleton;
import io.joynr.messaging.IMessagingStub;
import io.joynr.messaging.MessagingSkeletonFactory;
import io.joynr.messaging.MulticastReceiverRegistrar;
import io.joynr.messaging.SuccessAction;
import io.joynr.messaging.inprocess.InProcessAddress;
import io.joynr.messaging.routing.AddressManager;
import io.joynr.messaging.routing.DelayableImmutableMessage;
import io.joynr.messaging.routing.MessageProcessedHandler;
import io.joynr.messaging.routing.MessageProcessedListener;
import io.joynr.messaging.routing.MessageQueue;
import io.joynr.messaging.routing.MessageRouter;
import io.joynr.messaging.routing.MessagingStubFactory;
import io.joynr.messaging.routing.MulticastReceiverRegistry;
import io.joynr.messaging.routing.RoutingTable;
import io.joynr.runtime.ShutdownListener;
import io.joynr.runtime.ShutdownNotifier;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Singleton;
import joynr.ImmutableMessage;
import joynr.Message;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.LocalAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageRouter
implements MessageRouter,
MessageProcessedHandler,
MulticastReceiverRegistrar,
ShutdownListener {
    static final Set<Message.MessageType> MESSAGE_TYPE_REQUESTS = new HashSet<Message.MessageType>(Arrays.asList(Message.MessageType.VALUE_MESSAGE_TYPE_REQUEST, Message.MessageType.VALUE_MESSAGE_TYPE_SUBSCRIPTION_REQUEST, Message.MessageType.VALUE_MESSAGE_TYPE_BROADCAST_SUBSCRIPTION_REQUEST, Message.MessageType.VALUE_MESSAGE_TYPE_MULTICAST_SUBSCRIPTION_REQUEST));
    static final Set<Message.MessageType> MESSAGE_TYPE_REPLIES = new HashSet<Message.MessageType>(Arrays.asList(Message.MessageType.VALUE_MESSAGE_TYPE_REPLY, Message.MessageType.VALUE_MESSAGE_TYPE_SUBSCRIPTION_REPLY));
    private static final Logger logger = LoggerFactory.getLogger(AbstractMessageRouter.class);
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss:sss z");
    protected final RoutingTable routingTable;
    private ScheduledExecutorService scheduler;
    private long sendMsgRetryIntervalMs;
    private long routingTableCleanupIntervalMs;
    @Inject(optional=true)
    @Named(value="joynr.messaging.routingmaxretrycount")
    private long maxRetryCount = -1L;
    @Inject(optional=true)
    @Named(value="joynr.messaging.maxDelayWithExponentialBackoffMs")
    private long maxDelayMs = -1L;
    private MessagingStubFactory messagingStubFactory;
    private final MessagingSkeletonFactory messagingSkeletonFactory;
    private AddressManager addressManager;
    protected final MulticastReceiverRegistry multicastReceiverRegistry;
    private final MessageQueue messageQueue;
    private List<MessageProcessedListener> messageProcessedListeners;
    private List<MessageWorker> messageWorkers;
    private final ConcurrentHashMap<WeakReference<Object>, ProxyInformation> proxyMap;
    private final ReferenceQueue<Object> garbageCollectedProxiesQueue;
    private final ShutdownNotifier shutdownNotifier;
    private final ConcurrentHashMap<String, ProxyInformation> proxyParticipantIdToProxyInformationMap;

    @Inject
    @Singleton
    public AbstractMessageRouter(RoutingTable routingTable, @Named(value="io.joynr.messaging.scheduledthreadpool") ScheduledExecutorService scheduler, @Named(value="joynr.messaging.sendmsgretryintervalms") long sendMsgRetryIntervalMs, @Named(value="joynr.messaging.maximumparallelsends") int maxParallelSends, @Named(value="joynr.messaging.routingtablecleanupintervalms") long routingTableCleanupIntervalMs, MessagingStubFactory messagingStubFactory, MessagingSkeletonFactory messagingSkeletonFactory, AddressManager addressManager, MulticastReceiverRegistry multicastReceiverRegistry, MessageQueue messageQueue, ShutdownNotifier shutdownNotifier) {
        this.dateFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.routingTable = routingTable;
        this.scheduler = scheduler;
        this.sendMsgRetryIntervalMs = sendMsgRetryIntervalMs;
        this.routingTableCleanupIntervalMs = routingTableCleanupIntervalMs;
        this.messagingStubFactory = messagingStubFactory;
        this.messagingSkeletonFactory = messagingSkeletonFactory;
        this.addressManager = addressManager;
        this.multicastReceiverRegistry = multicastReceiverRegistry;
        this.messageQueue = messageQueue;
        this.proxyMap = new ConcurrentHashMap();
        this.proxyParticipantIdToProxyInformationMap = new ConcurrentHashMap();
        this.garbageCollectedProxiesQueue = new ReferenceQueue();
        this.shutdownNotifier = shutdownNotifier;
        shutdownNotifier.registerForShutdown(this);
        this.messageProcessedListeners = new ArrayList<MessageProcessedListener>();
        this.startMessageWorkerThreads(maxParallelSends);
        this.startRoutingTableCleanupThread();
    }

    private void startMessageWorkerThreads(int numberOfWorkThreads) {
        this.messageWorkers = new ArrayList<MessageWorker>(numberOfWorkThreads);
        for (int i = 0; i < numberOfWorkThreads; ++i) {
            MessageWorker messageWorker = new MessageWorker(i);
            this.scheduler.schedule(messageWorker, 0L, TimeUnit.MILLISECONDS);
            this.messageWorkers.add(messageWorker);
        }
    }

    private void startRoutingTableCleanupThread() {
        this.scheduler.scheduleWithFixedDelay(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Reference r;
                AbstractMessageRouter.this.routingTable.purge();
                ReferenceQueue referenceQueue = AbstractMessageRouter.this.garbageCollectedProxiesQueue;
                synchronized (referenceQueue) {
                    r = AbstractMessageRouter.this.garbageCollectedProxiesQueue.poll();
                }
                while (r != null) {
                    ProxyInformation proxyInformation = (ProxyInformation)AbstractMessageRouter.this.proxyMap.get(r);
                    logger.debug("Removing garbage collected proxy participantId {}", (Object)proxyInformation.participantId);
                    AbstractMessageRouter.this.removeNextHop(proxyInformation.participantId);
                    for (String providerParticipantId : proxyInformation.providerParticipantIds) {
                        AbstractMessageRouter.this.removeNextHop(providerParticipantId);
                    }
                    AbstractMessageRouter.this.shutdownNotifier.unregister(proxyInformation.shutdownListener);
                    AbstractMessageRouter.this.proxyMap.remove(r);
                    AbstractMessageRouter.this.proxyParticipantIdToProxyInformationMap.remove(proxyInformation.participantId);
                    ReferenceQueue referenceQueue2 = AbstractMessageRouter.this.garbageCollectedProxiesQueue;
                    synchronized (referenceQueue2) {
                        r = AbstractMessageRouter.this.garbageCollectedProxiesQueue.poll();
                    }
                }
            }
        }, this.routingTableCleanupIntervalMs, this.routingTableCleanupIntervalMs, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerMessageProcessedListener(MessageProcessedListener messageProcessedListener) {
        List<MessageProcessedListener> list = this.messageProcessedListeners;
        synchronized (list) {
            this.messageProcessedListeners.add(messageProcessedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterMessageProcessedListener(MessageProcessedListener messageProcessedListener) {
        List<MessageProcessedListener> list = this.messageProcessedListeners;
        synchronized (list) {
            this.messageProcessedListeners.remove(messageProcessedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageProcessed(String messageId) {
        List<MessageProcessedListener> list = this.messageProcessedListeners;
        synchronized (list) {
            for (MessageProcessedListener messageProcessedListener : this.messageProcessedListeners) {
                messageProcessedListener.messageProcessed(messageId);
            }
        }
    }

    @Override
    public void removeNextHop(String participantId) {
        this.routingTable.remove(participantId);
    }

    @Override
    public boolean resolveNextHop(String participantId) {
        return this.routingTable.containsKey(participantId);
    }

    @Override
    public void addMulticastReceiver(final String multicastId, String subscriberParticipantId, String providerParticipantId) {
        if (!this.routingTable.containsKey(providerParticipantId)) {
            logger.error("The provider {} is not known, multicast receiver will not be added.", (Object)providerParticipantId);
            throw new JoynrIllegalStateException("The provider " + providerParticipantId + " is not known, multicast receiver will not be added.");
        }
        logger.trace("Adding multicast receiver {} for multicast {} on provider {}", new Object[]{subscriberParticipantId, multicastId, providerParticipantId});
        this.multicastReceiverRegistry.registerMulticastReceiver(multicastId, subscriberParticipantId);
        this.performSubscriptionOperation(multicastId, providerParticipantId, new SubscriptionOperation(){

            @Override
            public void perform(IMessagingMulticastSubscriber messagingMulticastSubscriber) {
                messagingMulticastSubscriber.registerMulticastSubscription(multicastId);
            }
        });
    }

    @Override
    public void removeMulticastReceiver(final String multicastId, String subscriberParticipantId, String providerParticipantId) {
        this.multicastReceiverRegistry.unregisterMulticastReceiver(multicastId, subscriberParticipantId);
        if (!this.routingTable.containsKey(providerParticipantId)) {
            logger.error("The provider {} is not known, multicast receiver cannot be removed.", (Object)providerParticipantId);
            throw new JoynrIllegalStateException("The provider " + providerParticipantId + " is not known, multicast receiver will not be added.");
        }
        this.performSubscriptionOperation(multicastId, providerParticipantId, new SubscriptionOperation(){

            @Override
            public void perform(IMessagingMulticastSubscriber messagingMulticastSubscriber) {
                messagingMulticastSubscriber.unregisterMulticastSubscription(multicastId);
            }
        });
    }

    private void performSubscriptionOperation(String multicastId, String providerParticipantId, SubscriptionOperation operation) {
        Address providerAddress = this.routingTable.get(providerParticipantId);
        Optional<IMessagingSkeleton> messagingSkeleton = this.messagingSkeletonFactory.getSkeleton(providerAddress);
        if (messagingSkeleton.isPresent() && messagingSkeleton.get() instanceof IMessagingMulticastSubscriber) {
            operation.perform((IMessagingMulticastSubscriber)((Object)messagingSkeleton.get()));
        } else {
            logger.trace("No messaging skeleton found for address {}, not performing multicast subscription.", (Object)providerAddress);
        }
    }

    @Override
    public void addNextHop(String participantId, Address address, boolean isGloballyVisible) {
        long expiryDateMs = Long.MAX_VALUE;
        this.routingTable.put(participantId, address, isGloballyVisible, Long.MAX_VALUE);
    }

    protected void route(ImmutableMessage message) {
        this.checkExpiry(message);
        this.routeInternal(message, 0L, 0);
    }

    protected Set<String> getRecipients(ImmutableMessage message) {
        return this.addressManager.getParticipantIdsForImmutableMessage(message);
    }

    private void checkFoundAddress(Optional<Address> foundAddress, ImmutableMessage message) {
        if (!foundAddress.isPresent()) {
            if (Message.MessageType.VALUE_MESSAGE_TYPE_MULTICAST.equals((Object)message.getType())) {
                throw new JoynrMessageNotSentException("Failed to route multicast publication: No address found for given message.");
            }
            if (Message.MessageType.VALUE_MESSAGE_TYPE_PUBLICATION.equals((Object)message.getType())) {
                throw new JoynrMessageNotSentException("Failed to route publication: No address found for given message.");
            }
            if (message.isReply()) {
                throw new JoynrMessageNotSentException("Failed to route reply: No address found for given message.");
            }
            throw new JoynrIllegalStateException("Unable to find addresses for message.");
        }
    }

    private void routeInternal(ImmutableMessage message, long delayMs, int retriesCount) {
        logger.trace("Scheduling message {} with delay {} and retries {}", new Object[]{message, delayMs, retriesCount});
        Set<String> recipients = this.getRecipients(message);
        if (recipients.isEmpty()) {
            String errormessage = "Failed to route multicast publication: No recipient found for given message: " + message.getTrackingInfo();
            logger.error("ERROR SENDING: aborting send. Error:", (Object)errormessage);
            this.finalizeMessageProcessing(message, false);
        }
        for (String recipient : recipients) {
            DelayableImmutableMessage delayableMessage = new DelayableImmutableMessage(message, delayMs, recipient, retriesCount);
            this.scheduleMessage(delayableMessage);
        }
    }

    private void scheduleMessage(DelayableImmutableMessage delayableMessage) {
        int retriesCount = delayableMessage.getRetriesCount();
        if (this.maxRetryCount > -1L && (long)retriesCount > this.maxRetryCount) {
            logger.error("Max-retry-count ({}) reached. Dropping message {}", (Object)this.maxRetryCount, (Object)delayableMessage.getMessage().getTrackingInfo());
            this.finalizeMessageProcessing(delayableMessage.getMessage(), false);
            return;
        }
        if (retriesCount > 0) {
            logger.debug("Retry {}/{} sending message {}", new Object[]{retriesCount, this.maxRetryCount, delayableMessage.getMessage().getTrackingInfo()});
        }
        this.messageQueue.put(delayableMessage);
    }

    private boolean isExpired(ImmutableMessage message) {
        if (!message.isTtlAbsolute()) {
            return true;
        }
        return message.getTtlMs() <= System.currentTimeMillis();
    }

    private void checkExpiry(ImmutableMessage message) {
        if (!message.isTtlAbsolute()) {
            this.finalizeMessageProcessing(message, false);
            throw new JoynrRuntimeException("Relative ttl not supported");
        }
        if (this.isExpired(message)) {
            long currentTimeMillis = System.currentTimeMillis();
            String errorMessage = MessageFormat.format("Received expired message: (now ={0}). Dropping the message {1}", currentTimeMillis, message.getTrackingInfo());
            logger.trace(errorMessage);
            this.finalizeMessageProcessing(message, false);
            throw new JoynrMessageExpiredException(errorMessage);
        }
    }

    protected ImmutableMessage createReplyMessageWithError(ImmutableMessage requestMessage, JoynrRuntimeException error) {
        return null;
    }

    private FailureAction createFailureAction(final DelayableImmutableMessage delayableMessage) {
        FailureAction failureAction = new FailureAction(){
            private final AtomicBoolean failureActionExecutedOnce = new AtomicBoolean(false);

            @Override
            public void execute(Throwable error) {
                ImmutableMessage messageNotSent = delayableMessage.getMessage();
                if (!this.failureActionExecutedOnce.compareAndSet(false, true)) {
                    logger.trace("Failure action for message {} already executed once. Ignoring further call.", (Object)messageNotSent.getTrackingInfo());
                    return;
                }
                if (error instanceof JoynrShutdownException) {
                    logger.warn("Caught JoynrShutdownException while handling message {}:", (Object)messageNotSent.getTrackingInfo(), (Object)error);
                    return;
                }
                if (error instanceof JoynrMessageNotSentException) {
                    ImmutableMessage replyMessage;
                    logger.error("ERROR SENDING: Aborting send of message {}, Error:", (Object)messageNotSent.getTrackingInfo(), (Object)error);
                    if (!AbstractMessageRouter.this.isExpired(messageNotSent) && messageNotSent.getType().equals((Object)Message.MessageType.VALUE_MESSAGE_TYPE_REQUEST) && (replyMessage = AbstractMessageRouter.this.createReplyMessageWithError(messageNotSent, (JoynrRuntimeException)((Object)((JoynrMessageNotSentException)error)))) != null) {
                        AbstractMessageRouter.this.routeInternal(replyMessage, 0L, 0);
                        AbstractMessageRouter.this.finalizeMessageProcessing(messageNotSent, true);
                        return;
                    }
                    AbstractMessageRouter.this.finalizeMessageProcessing(messageNotSent, false);
                    return;
                }
                logger.warn("PROBLEM SENDING, will retry. message: {}, Error:", (Object)messageNotSent.getTrackingInfo(), (Object)error);
                long delayMs = error instanceof JoynrDelayMessageException ? ((JoynrDelayMessageException)error).getDelayMs() : AbstractMessageRouter.this.createDelayWithExponentialBackoff(AbstractMessageRouter.this.sendMsgRetryIntervalMs, delayableMessage.getRetriesCount());
                delayableMessage.setDelay(delayMs);
                delayableMessage.setRetriesCount(delayableMessage.getRetriesCount() + 1);
                logger.warn("Rescheduling message {} with delay {} ms, TTL: {}, retries: {}", new Object[]{messageNotSent.getTrackingInfo(), delayMs, AbstractMessageRouter.this.dateFormatter.format(delayableMessage.getMessage().getTtlMs()), delayableMessage.getRetriesCount()});
                try {
                    AbstractMessageRouter.this.scheduleMessage(delayableMessage);
                }
                catch (Exception e) {
                    logger.warn("Rescheduling of message {} failed", (Object)messageNotSent.getTrackingInfo());
                    AbstractMessageRouter.this.finalizeMessageProcessing(messageNotSent, false);
                }
            }
        };
        return failureAction;
    }

    protected void finalizeMessageProcessing(ImmutableMessage message, boolean isMessageRoutingsuccessful) {
        if (message.isMessageProcessed()) {
            return;
        }
        message.messageProcessed();
        this.decreaseReferenceCountsForMessage(message, isMessageRoutingsuccessful);
        this.messageProcessed(message.getId());
    }

    private SuccessAction createMessageProcessedAction(final ImmutableMessage message) {
        SuccessAction successAction = new SuccessAction(){

            @Override
            public void execute() {
                AbstractMessageRouter.this.finalizeMessageProcessing(message, true);
            }
        };
        return successAction;
    }

    @Override
    public void prepareForShutdown() {
        this.messageQueue.waitForQueueToDrain();
    }

    @Override
    public void shutdown() {
        CountDownLatch countDownLatch = new CountDownLatch(this.messageWorkers.size());
        for (MessageWorker worker : this.messageWorkers) {
            worker.stopWorker(countDownLatch);
        }
        try {
            countDownLatch.await(1500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            logger.error("Interrupted while waiting for message workers to stop.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerProxy(Object proxy, String proxyParticipantId, ShutdownListener shutdownListener) {
        ReferenceQueue<Object> referenceQueue = this.garbageCollectedProxiesQueue;
        synchronized (referenceQueue) {
            ProxyInformation proxyInformation = new ProxyInformation(proxyParticipantId, shutdownListener);
            if (this.proxyParticipantIdToProxyInformationMap.putIfAbsent(proxyParticipantId, proxyInformation) != null) {
                throw new JoynrIllegalStateException("The proxy with " + proxyParticipantId + " has already been registered.");
            }
            logger.debug("registerProxy called for {}", (Object)proxyParticipantId);
            this.proxyMap.put(new WeakReference<Object>(proxy, this.garbageCollectedProxiesQueue), proxyInformation);
        }
    }

    @Override
    public void registerProxyProviderParticipantIds(String proxyParticipantId, Set<String> providerParticipantIds) {
        if (proxyParticipantId == null || proxyParticipantId.isEmpty()) {
            throw new JoynrIllegalStateException("Proxy participant id is null or has an empty value.Registration of proxy's provider participant ids failed.");
        }
        if (providerParticipantIds == null || providerParticipantIds.isEmpty()) {
            throw new JoynrIllegalStateException("Set of the provider participant ids is null or empty.Registration of proxy's provider participant ids failed.");
        }
        if (providerParticipantIds.contains(null) || providerParticipantIds.contains("")) {
            throw new JoynrIllegalStateException("Set of the provider participant ids has an entry with an empty or null value.Registration of proxy's provider participant ids failed.");
        }
        this.proxyParticipantIdToProxyInformationMap.computeIfPresent(proxyParticipantId, (key, oldVal) -> {
            if (oldVal.providerParticipantIds.isEmpty()) {
                oldVal.providerParticipantIds.addAll(providerParticipantIds);
                return oldVal;
            }
            throw new JoynrIllegalStateException("The proxy with " + proxyParticipantId + " already has registered providers. Registration of proxy's provider participant ids failed.");
        });
    }

    private long createDelayWithExponentialBackoff(long sendMsgRetryIntervalMs, int retries) {
        long millis = sendMsgRetryIntervalMs + (long)((double)((long)(2 ^ retries) * sendMsgRetryIntervalMs) * Math.random());
        if (this.maxDelayMs >= sendMsgRetryIntervalMs && millis > this.maxDelayMs) {
            millis = this.maxDelayMs;
        }
        logger.trace("Created delay of {}ms in retry {}", (Object)millis, (Object)retries);
        return millis;
    }

    private void decreaseReferenceCountsForMessage(ImmutableMessage message, boolean isMessageRoutingSuccessful) {
        Message.MessageType type = message.getType();
        if (!isMessageRoutingSuccessful && MESSAGE_TYPE_REQUESTS.contains((Object)type)) {
            if (!this.proxyParticipantIdToProxyInformationMap.containsKey(message.getSender()) && !(this.routingTable.get(message.getSender()) instanceof LocalAddress)) {
                this.routingTable.remove(message.getSender());
            }
        } else if (MESSAGE_TYPE_REPLIES.contains((Object)type) && !this.proxyParticipantIdToProxyInformationMap.containsKey(message.getRecipient()) && !(this.routingTable.get(message.getRecipient()) instanceof LocalAddress)) {
            if (type == Message.MessageType.VALUE_MESSAGE_TYPE_SUBSCRIPTION_REPLY && !(this.routingTable.get(message.getSender()) instanceof InProcessAddress)) {
                return;
            }
            this.routingTable.remove(message.getRecipient());
        }
    }

    class MessageWorker
    implements Runnable {
        private Logger logger = LoggerFactory.getLogger(MessageWorker.class);
        private int number;
        private volatile CountDownLatch countDownLatch;
        private volatile boolean stopped;

        public MessageWorker(int number) {
            this.number = number;
            this.countDownLatch = null;
            this.stopped = false;
        }

        void stopWorker(CountDownLatch countDownLatch) {
            this.countDownLatch = countDownLatch;
            this.stopped = true;
        }

        @Override
        public void run() {
            Thread.currentThread().setName("joynrMessageWorker-" + this.number);
            while (!this.stopped) {
                DelayableImmutableMessage delayableMessage = null;
                FailureAction failureAction = null;
                try {
                    delayableMessage = AbstractMessageRouter.this.messageQueue.poll(1000L, TimeUnit.MILLISECONDS);
                    if (delayableMessage == null) continue;
                    ImmutableMessage message = delayableMessage.getMessage();
                    this.logger.trace("Starting processing of message {}", (Object)message);
                    AbstractMessageRouter.this.checkExpiry(message);
                    Optional<Address> optionalAddress = AbstractMessageRouter.this.addressManager.getAddressForDelayableImmutableMessage(delayableMessage);
                    try {
                        AbstractMessageRouter.this.checkFoundAddress(optionalAddress, message);
                    }
                    catch (JoynrMessageNotSentException error) {
                        this.logger.error("ERROR SENDING: aborting send of message: {}. Error:", (Object)message.getTrackingInfo(), (Object)error);
                        AbstractMessageRouter.this.finalizeMessageProcessing(message, false);
                        continue;
                    }
                    catch (Exception error) {
                        this.logger.debug("ERROR SENDING: retrying send of message. Error:", (Throwable)error);
                        long delayMs = AbstractMessageRouter.this.createDelayWithExponentialBackoff(AbstractMessageRouter.this.sendMsgRetryIntervalMs, delayableMessage.getRetriesCount() + 1);
                        delayableMessage.setDelay(delayMs);
                        delayableMessage.setRetriesCount(delayableMessage.getRetriesCount() + 1);
                        AbstractMessageRouter.this.scheduleMessage(delayableMessage);
                        continue;
                    }
                    SuccessAction messageProcessedAction = AbstractMessageRouter.this.createMessageProcessedAction(message);
                    failureAction = AbstractMessageRouter.this.createFailureAction(delayableMessage);
                    Address address = optionalAddress.get();
                    this.logger.trace(">>>>> SEND message {} to address {}", (Object)message.getId(), (Object)address);
                    IMessagingStub messagingStub = AbstractMessageRouter.this.messagingStubFactory.create(address);
                    messagingStub.transmit(message, messageProcessedAction, failureAction);
                }
                catch (InterruptedException e) {
                    this.logger.trace("Message Worker interrupted. Stopping.");
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (Exception error) {
                    if (delayableMessage == null) {
                        this.logger.error("Error in scheduled message router thread. delayableMessage == null, continuing. Error:", (Throwable)error);
                        continue;
                    }
                    this.logger.error("Error in scheduled message router thread:", (Throwable)error);
                    if (failureAction == null) {
                        failureAction = AbstractMessageRouter.this.createFailureAction(delayableMessage);
                    }
                    failureAction.execute(error);
                }
            }
            this.countDownLatch.countDown();
        }
    }

    private static interface SubscriptionOperation {
        public void perform(IMessagingMulticastSubscriber var1);
    }

    protected static class ProxyInformation {
        public String participantId;
        public ShutdownListener shutdownListener;
        public final Set<String> providerParticipantIds;

        public ProxyInformation(String participantId, ShutdownListener shutdownListener) {
            this.participantId = participantId;
            this.shutdownListener = shutdownListener;
            this.providerParticipantIds = new HashSet<String>();
        }
    }
}

