/*
 * Decompiled with CFR 0.152.
 */
package joynr;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.joynr.smrf.EncodingException;
import io.joynr.smrf.MessageDeserializer;
import io.joynr.smrf.MessageDeserializerImpl;
import io.joynr.smrf.UnsuppportedVersionException;
import io.joynr.util.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import joynr.Message;

public class ImmutableMessage
extends Message {
    private transient boolean receivedFromGlobal;
    private transient boolean isMessageProcessed = false;
    private final MessageDeserializer messageDeserializer;
    private final byte[] serializedMessage;
    private transient Map<String, Serializable> context = new HashMap<String, Serializable>();
    private ObjectMapper objectMapper = null;
    public static final String DUMMY_CREATOR_USER_ID = "creatorUserId";

    public ImmutableMessage(byte[] serializedMessage) throws EncodingException, UnsuppportedVersionException {
        this.serializedMessage = (byte[])serializedMessage.clone();
        this.messageDeserializer = new MessageDeserializerImpl(this.serializedMessage);
    }

    @JsonIgnore
    public byte[] getSerializedMessage() {
        return (byte[])this.serializedMessage.clone();
    }

    public long getTtlMs() {
        return this.messageDeserializer.getTtlMs();
    }

    public boolean isTtlAbsolute() {
        return this.messageDeserializer.isTtlAbsolute();
    }

    public String getSender() {
        return this.messageDeserializer.getSender();
    }

    public String getRecipient() {
        return this.messageDeserializer.getRecipient();
    }

    public String getReplyTo() {
        return this.messageDeserializer.getHeader("re");
    }

    public Message.MessageType getType() {
        return Message.MessageType.fromString(this.messageDeserializer.getHeader("t"));
    }

    public String getEffort() {
        return this.messageDeserializer.getHeader("ef");
    }

    public String getCreatorUserId() {
        return DUMMY_CREATOR_USER_ID;
    }

    public byte[] getUnencryptedBody() throws EncodingException {
        return this.messageDeserializer.getUnencryptedBody();
    }

    public Map<String, String> getHeaders() {
        return this.messageDeserializer.getHeaders();
    }

    public Map<String, String> getCustomHeaders() {
        HashMap<String, String> customHeaders = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.getHeaders().entrySet()) {
            if (!entry.getKey().startsWith("c-")) continue;
            String key = entry.getKey().replaceFirst("^c-", "");
            customHeaders.put(key, entry.getValue());
        }
        return customHeaders;
    }

    public void setContext(HashMap<String, Serializable> context) {
        this.context = context;
    }

    public Map<String, Serializable> getContext() {
        return this.context;
    }

    public void setReceivedFromGlobal(boolean receivedFromGlobal) {
        this.receivedFromGlobal = receivedFromGlobal;
    }

    public boolean isReceivedFromGlobal() {
        return this.receivedFromGlobal;
    }

    public void messageProcessed() {
        this.isMessageProcessed = true;
    }

    public boolean isMessageProcessed() {
        return this.isMessageProcessed;
    }

    public String getId() {
        return this.messageDeserializer.getHeader("id");
    }

    public boolean isEncrypted() {
        return this.messageDeserializer.isEncrypted();
    }

    public boolean isSigned() {
        return this.messageDeserializer.isSigned();
    }

    public boolean isCompressed() {
        return this.messageDeserializer.isCompressed();
    }

    @JsonIgnore
    public int getMessageSize() {
        return this.messageDeserializer.getMessageSize();
    }

    @JsonIgnore
    public String toLogMessage() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
            SimpleModule module = new SimpleModule();
            module.addSerializer(byte[].class, (JsonSerializer)new PayloadSerializer(byte[].class));
            module.addSerializer(Message.MessageType.class, (JsonSerializer)new TypeSerializer(Message.MessageType.class));
            this.objectMapper.registerModule((Module)module);
        }
        try {
            return this.objectMapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            return "";
        }
    }

    public String toString() {
        return this.toLogMessage();
    }

    public boolean isReply() {
        Message.MessageType messageType = this.getType();
        return Message.MessageType.VALUE_MESSAGE_TYPE_REPLY.equals((Object)messageType) || Message.MessageType.VALUE_MESSAGE_TYPE_SUBSCRIPTION_REPLY.equals((Object)messageType);
    }

    public String getTrackingInfo() {
        String requestReplyId = this.getCustomHeaders().get("z4");
        StringBuilder trackingInfo = new StringBuilder(256).append("messageId: ").append(this.getId()).append(", type: ").append((Object)this.getType()).append(", sender: ").append(this.getSender()).append(", recipient: ").append(this.getRecipient());
        if (requestReplyId != null) {
            trackingInfo.append(", requestReplyId: ").append(requestReplyId);
        }
        trackingInfo.append(", expiryDate: ").append(this.getTtlMs()).append(", size: ").append(this.getMessageSize());
        return trackingInfo.toString();
    }

    private static class TypeSerializer
    extends StdSerializer<Message.MessageType> {
        private static final long serialVersionUID = 1L;

        protected TypeSerializer(Class<Message.MessageType> t) {
            super(t);
        }

        public void serialize(Message.MessageType value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            if (value == null) {
                gen.writeString("null");
            } else {
                gen.writeString(value.toString());
            }
        }
    }

    private static class PayloadSerializer
    extends StdSerializer<byte[]> {
        private static final long serialVersionUID = 1L;

        protected PayloadSerializer(Class<byte[]> t) {
            super(t);
        }

        public void serialize(byte[] value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(new String(value, StandardCharsets.UTF_8));
        }
    }
}

