/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.routing;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.joynr.messaging.routing.MulticastReceiverRegistry;
import io.joynr.messaging.util.MulticastWildcardRegexFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class InMemoryMulticastReceiverRegistry
implements MulticastReceiverRegistry {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryMulticastReceiverRegistry.class);
    private final MulticastWildcardRegexFactory multicastWildcardRegexFactory;
    private ConcurrentMap<Pattern, Set<String>> multicastReceivers = new ConcurrentHashMap<Pattern, Set<String>>();

    @Inject
    public InMemoryMulticastReceiverRegistry(MulticastWildcardRegexFactory multicastWildcardRegexFactory) {
        this.multicastWildcardRegexFactory = multicastWildcardRegexFactory;
    }

    @Override
    public void registerMulticastReceiver(String multicastId, String participantId) {
        Pattern idPattern = this.multicastWildcardRegexFactory.createIdPattern(multicastId);
        logger.trace("Compiled pattern {} for multicast ID {}", (Object)idPattern, (Object)multicastId);
        if (!this.multicastReceivers.containsKey(idPattern)) {
            this.multicastReceivers.putIfAbsent(idPattern, new HashSet());
        }
        ((Set)this.multicastReceivers.get(idPattern)).add(participantId);
    }

    @Override
    public void unregisterMulticastReceiver(String multicastId, String participantId) {
        Set participants = (Set)this.multicastReceivers.get(this.multicastWildcardRegexFactory.createIdPattern(multicastId));
        if (participants != null) {
            participants.remove(participantId);
        }
    }

    @Override
    public Set<String> getReceivers(String multicastId) {
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry entry : this.multicastReceivers.entrySet()) {
            if (!((Pattern)entry.getKey()).matcher(multicastId).matches()) continue;
            result.addAll((Collection)entry.getValue());
        }
        return result;
    }

    @Override
    public Map<String, Set<String>> getReceivers() {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (Map.Entry entry : this.multicastReceivers.entrySet()) {
            result.put(((Pattern)entry.getKey()).pattern(), Collections.unmodifiableSet((Set)entry.getValue()));
        }
        return result;
    }
}

