/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.routing;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import joynr.ImmutableMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageRouterUtil {
    private static final Logger logger = LoggerFactory.getLogger(MessageRouterUtil.class);
    @Inject
    @Named(value="joynr.messaging.sendmsgretryintervalms")
    private static long sendMsgRetryIntervalMs;
    @Inject(optional=true)
    @Named(value="joynr.messaging.maxDelayWithExponentialBackoffMs")
    private static long maxDelayMs;

    public static boolean isExpired(ImmutableMessage message) {
        if (!message.isTtlAbsolute()) {
            return true;
        }
        return message.getTtlMs() <= System.currentTimeMillis();
    }

    public static long createDelayWithExponentialBackoff(int retries) {
        long millis = sendMsgRetryIntervalMs + (long)((double)((long)(2 ^ retries) * sendMsgRetryIntervalMs) * Math.random());
        if (maxDelayMs >= sendMsgRetryIntervalMs && millis > maxDelayMs) {
            millis = maxDelayMs;
        }
        logger.trace("Created delay of {}ms in retry {}", (Object)millis, (Object)retries);
        return millis;
    }

    static {
        maxDelayMs = -1L;
    }
}

