/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.routing;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.joynr.messaging.routing.MulticastReceiverRegistry;
import io.joynr.messaging.util.MulticastWildcardRegexFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class InMemoryMulticastReceiverRegistry
implements MulticastReceiverRegistry {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryMulticastReceiverRegistry.class);
    private final MulticastWildcardRegexFactory multicastWildcardRegexFactory;
    private HashMap<String, PatternEntry> multicastReceivers = new HashMap();

    @Inject
    public InMemoryMulticastReceiverRegistry(MulticastWildcardRegexFactory multicastWildcardRegexFactory) {
        this.multicastWildcardRegexFactory = multicastWildcardRegexFactory;
    }

    @Override
    public synchronized void registerMulticastReceiver(String multicastId, String participantId) {
        PatternEntry patternEntry;
        if (!this.multicastReceivers.containsKey(multicastId)) {
            Pattern idPattern = this.multicastWildcardRegexFactory.createIdPattern(multicastId);
            logger.trace("Compiled pattern {} for multicast ID {}", (Object)idPattern, (Object)multicastId);
            patternEntry = new PatternEntry(idPattern);
            this.multicastReceivers.put(multicastId, patternEntry);
        } else {
            patternEntry = this.multicastReceivers.get(multicastId);
        }
        patternEntry.getParticipantIds().add(participantId);
    }

    @Override
    public synchronized void unregisterMulticastReceiver(String multicastId, String participantId) {
        PatternEntry patternEntry = this.multicastReceivers.get(multicastId);
        if (patternEntry != null) {
            patternEntry.getParticipantIds().remove(participantId);
            if (patternEntry.getParticipantIds().size() == 0) {
                this.multicastReceivers.remove(multicastId);
            }
        }
    }

    @Override
    public synchronized Set<String> getReceivers(String multicastId) {
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<String, PatternEntry> entry : this.multicastReceivers.entrySet()) {
            if (!entry.getValue().getPattern().matcher(multicastId).matches()) continue;
            result.addAll(entry.getValue().getParticipantIds());
        }
        return result;
    }

    @Override
    public synchronized Map<String, Set<String>> getReceivers() {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (Map.Entry<String, PatternEntry> entry : this.multicastReceivers.entrySet()) {
            result.put(entry.getValue().getPattern().pattern(), Collections.unmodifiableSet(entry.getValue().getParticipantIds()));
        }
        return result;
    }

    private static class PatternEntry {
        private Pattern pattern;
        private Set<String> participantIds = new HashSet<String>();

        public PatternEntry(Pattern pattern) {
            this.pattern = pattern;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public Set<String> getParticipantIds() {
            return this.participantIds;
        }
    }
}

