/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.sender;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.joynr.messaging.routing.MessageRouter;
import io.joynr.messaging.sender.AbstractMessageSender;
import io.joynr.runtime.GlobalAddressProvider;
import io.joynr.runtime.ReplyToAddressProvider;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.RoutingTypesUtil;

@Singleton
public class CcMessageSender
extends AbstractMessageSender {
    private String replyToAddress;
    private String globalAddress;

    @Inject
    public CcMessageSender(MessageRouter messageRouter, ReplyToAddressProvider replyToAddressProvider, GlobalAddressProvider globalAddressProvider) {
        super(messageRouter);
        replyToAddressProvider.registerGlobalAddressesReadyListener(address -> this.addReplyToAddress(RoutingTypesUtil.toAddressString((Address)((Address)address.get()))));
        globalAddressProvider.registerGlobalAddressesReadyListener(address -> this.addGlobalAddress(RoutingTypesUtil.toAddressString((Address)((Address)address.get()))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addReplyToAddress(String replyToAddress) {
        CcMessageSender ccMessageSender = this;
        synchronized (ccMessageSender) {
            this.replyToAddress = replyToAddress;
        }
        this.triggerSetReplyToAddressIfReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addGlobalAddress(String globalAddress) {
        CcMessageSender ccMessageSender = this;
        synchronized (ccMessageSender) {
            this.globalAddress = globalAddress;
        }
        this.triggerSetReplyToAddressIfReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerSetReplyToAddressIfReady() {
        CcMessageSender ccMessageSender = this;
        synchronized (ccMessageSender) {
            if (this.replyToAddress != null && this.globalAddress != null) {
                this.setReplyToAddress(this.replyToAddress, this.globalAddress);
            }
        }
    }
}

