/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.runtime;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import io.joynr.messaging.NoBackendGlobalAddressFactory;
import io.joynr.messaging.routing.GlobalAddressFactory;
import io.joynr.messaging.routing.TransportReadyListener;
import java.util.Set;
import joynr.system.RoutingTypes.Address;

public class GlobalAddressProvider
implements Provider<Address> {
    public static final String GLOBAL_ADDRESS_FACTORIES = "global_address_factories";
    private GlobalAddressFactory<? extends Address> addressFactory;

    @Inject
    public GlobalAddressProvider(@Named(value="global_address_factories") Set<GlobalAddressFactory<? extends Address>> addressFactories) {
        if (addressFactories.size() == 1) {
            this.addressFactory = addressFactories.iterator().next();
        } else if (addressFactories.size() == 0) {
            this.addressFactory = new NoBackendGlobalAddressFactory();
        } else {
            throw new IllegalStateException("Multiple global transports were registered");
        }
    }

    public void registerGlobalAddressesReadyListener(TransportReadyListener listener) {
        this.addressFactory.registerGlobalAddressReady(listener);
    }

    public Address get() {
        try {
            return this.addressFactory.create();
        }
        catch (IllegalStateException e) {
            return null;
        }
    }
}

