/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.runtime;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import io.joynr.messaging.NoBackendGlobalAddressFactory;
import io.joynr.messaging.routing.GlobalAddressFactory;
import io.joynr.messaging.routing.TransportReadyListener;
import java.util.Set;
import joynr.system.RoutingTypes.Address;

public class ReplyToAddressProvider
implements Provider<Address> {
    public static final String REPLY_TO_ADDRESS_FACTORIES = "reply_to_address_factories";
    private GlobalAddressFactory<? extends Address> replyToAddressFactory;

    @Inject
    public ReplyToAddressProvider(@Named(value="reply_to_address_factories") Set<GlobalAddressFactory<? extends Address>> addressFactories) {
        if (addressFactories.size() == 1) {
            this.replyToAddressFactory = addressFactories.iterator().next();
        } else if (addressFactories.size() == 0) {
            this.replyToAddressFactory = new NoBackendGlobalAddressFactory();
        } else {
            throw new IllegalStateException("Multiple global transports were registered");
        }
    }

    public void registerGlobalAddressesReadyListener(TransportReadyListener listener) {
        this.replyToAddressFactory.registerGlobalAddressReady(listener);
    }

    public Address get() {
        try {
            return this.replyToAddressFactory.create();
        }
        catch (IllegalStateException e) {
            return null;
        }
    }
}

