/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.runtime;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.joynr.runtime.PrepareForShutdownListener;
import io.joynr.runtime.ShutdownListener;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ShutdownNotifier {
    private static final Logger logger = LoggerFactory.getLogger(ShutdownNotifier.class);
    private static final String PROPERTY_PREPARE_FOR_SHUTDOWN_TIMEOUT = "joynr.runtime.prepareforshutdowntimeout";
    private static final String HIVEMQ_MQTT_CLIENT_FACTORY_CLASS_NAME = "io.joynr.messaging.mqtt.hivemq.client.HivemqMqttClientFactory";
    private static final String MESSAGE_TRACKER_FOR_GRACEFUL_SHUTDOWN_CLASS_NAME = "io.joynr.messaging.tracking.MessageTrackerForGracefulShutdown";
    private static final String PROXY_INVOCATION_HANDLER_CLASS_NAME = "io.joynr.proxy.ProxyInvocationHandler";
    private static final String UNEXPECTED_CLASS_MESSAGE = "Listener expected to be of class: %s, but is of class %s";
    private static final String DEDICATED_METHOD_REGISTRATION_REQUIRED_MESSAGE = "Use dedicated method to register this listener";
    private final List<PrepareForShutdownListener> prepareForShutdownListenerList = new LinkedList<PrepareForShutdownListener>();
    private final List<ShutdownListener> shutdownListenerList = new LinkedList<ShutdownListener>();
    private PrepareForShutdownListener hivemqMqttPrepareForShutdownListener;
    private PrepareForShutdownListener messageTrackerPrepareForShutdownListener;
    private ShutdownListener hivemqMqttShutdownListener;
    private ShutdownListener messageTrackerShutdownListener;
    private final List<PrepareForShutdownListener> proxyInvocationHandlerPrepareForShutdownListenerList = new LinkedList<PrepareForShutdownListener>();
    private final List<ShutdownListener> proxyInvocationHandlerShutdownListenerList = new LinkedList<ShutdownListener>();
    @Inject(optional=true)
    @Named(value="joynr.runtime.prepareforshutdowntimeout")
    private int prepareForShutdownTimeoutSec = 5;

    public void registerHivemqMqttPrepareForShutdownListener(PrepareForShutdownListener listener) throws IllegalArgumentException {
        String className = listener.getClass().getName();
        if (!className.equals(HIVEMQ_MQTT_CLIENT_FACTORY_CLASS_NAME)) {
            throw new IllegalArgumentException(String.format(UNEXPECTED_CLASS_MESSAGE, HIVEMQ_MQTT_CLIENT_FACTORY_CLASS_NAME, className));
        }
        this.hivemqMqttPrepareForShutdownListener = listener;
    }

    public void registerMessageTrackerPrepareForShutdownListener(PrepareForShutdownListener listener) throws IllegalArgumentException {
        String className = listener.getClass().getName();
        if (!className.equals(MESSAGE_TRACKER_FOR_GRACEFUL_SHUTDOWN_CLASS_NAME)) {
            throw new IllegalArgumentException(String.format(UNEXPECTED_CLASS_MESSAGE, MESSAGE_TRACKER_FOR_GRACEFUL_SHUTDOWN_CLASS_NAME, className));
        }
        this.messageTrackerPrepareForShutdownListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerProxyInvocationHandlerPrepareForShutdownListener(PrepareForShutdownListener listener) throws IllegalArgumentException {
        String className = listener.getClass().getName();
        if (!className.contains(PROXY_INVOCATION_HANDLER_CLASS_NAME)) {
            throw new IllegalArgumentException(String.format(UNEXPECTED_CLASS_MESSAGE, PROXY_INVOCATION_HANDLER_CLASS_NAME, className));
        }
        List<PrepareForShutdownListener> list = this.proxyInvocationHandlerPrepareForShutdownListenerList;
        synchronized (list) {
            this.proxyInvocationHandlerPrepareForShutdownListenerList.add(listener);
            logger.debug("PrepareForShutdownListener implementation of {} has been registered", (Object)className);
        }
    }

    public void registerHivemqMqttShutdownListener(ShutdownListener listener) throws IllegalArgumentException {
        String className = listener.getClass().getName();
        if (!className.equals(HIVEMQ_MQTT_CLIENT_FACTORY_CLASS_NAME)) {
            throw new IllegalArgumentException(String.format(UNEXPECTED_CLASS_MESSAGE, HIVEMQ_MQTT_CLIENT_FACTORY_CLASS_NAME, className));
        }
        this.hivemqMqttShutdownListener = listener;
    }

    public void registerMessageTrackerShutdownListener(ShutdownListener listener) throws IllegalArgumentException {
        String className = listener.getClass().getName();
        if (!className.equals(MESSAGE_TRACKER_FOR_GRACEFUL_SHUTDOWN_CLASS_NAME)) {
            throw new IllegalArgumentException(String.format(UNEXPECTED_CLASS_MESSAGE, MESSAGE_TRACKER_FOR_GRACEFUL_SHUTDOWN_CLASS_NAME, className));
        }
        this.messageTrackerShutdownListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerProxyInvocationHandlerShutdownListener(ShutdownListener listener) throws IllegalArgumentException {
        String className = listener.getClass().getName();
        if (!className.contains(PROXY_INVOCATION_HANDLER_CLASS_NAME)) {
            throw new IllegalArgumentException(String.format(UNEXPECTED_CLASS_MESSAGE, PROXY_INVOCATION_HANDLER_CLASS_NAME, className));
        }
        List<ShutdownListener> list = this.proxyInvocationHandlerShutdownListenerList;
        synchronized (list) {
            this.proxyInvocationHandlerShutdownListenerList.add(listener);
            logger.debug("ShutdownListener implementation of {} has been registered", (Object)className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForShutdown(ShutdownListener shutdownListener) throws IllegalArgumentException {
        if (this.isDedicatedRegistrationRequired(shutdownListener)) {
            throw new IllegalArgumentException(DEDICATED_METHOD_REGISTRATION_REQUIRED_MESSAGE);
        }
        List<ShutdownListener> list = this.shutdownListenerList;
        synchronized (list) {
            this.shutdownListenerList.add(0, shutdownListener);
            logger.trace("#ShutdownListeners: {}", (Object)this.shutdownListenerList.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerToBeShutdownAsLast(ShutdownListener shutdownListener) throws IllegalArgumentException {
        if (this.isDedicatedRegistrationRequired(shutdownListener)) {
            throw new IllegalArgumentException(DEDICATED_METHOD_REGISTRATION_REQUIRED_MESSAGE);
        }
        List<ShutdownListener> list = this.shutdownListenerList;
        synchronized (list) {
            this.shutdownListenerList.add(shutdownListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPrepareForShutdownListener(PrepareForShutdownListener prepareForShutdownListener) throws IllegalArgumentException {
        if (this.isDedicatedRegistrationRequired(prepareForShutdownListener)) {
            throw new IllegalArgumentException(DEDICATED_METHOD_REGISTRATION_REQUIRED_MESSAGE);
        }
        List<PrepareForShutdownListener> list = this.prepareForShutdownListenerList;
        synchronized (list) {
            this.prepareForShutdownListenerList.add(prepareForShutdownListener);
        }
    }

    private boolean isDedicatedRegistrationRequired(Object listener) {
        String className = listener.getClass().getName();
        return className.equals(HIVEMQ_MQTT_CLIENT_FACTORY_CLASS_NAME) || className.equals(MESSAGE_TRACKER_FOR_GRACEFUL_SHUTDOWN_CLASS_NAME) || className.contains(PROXY_INVOCATION_HANDLER_CLASS_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareForShutdown() throws InterruptedException {
        Collection<CompletableFuture<Void>> proxyPrepareForShutdownFutures;
        logger.debug("prepareForShutdown invoked");
        if (this.hivemqMqttPrepareForShutdownListener != null) {
            this.hivemqMqttPrepareForShutdownListener.prepareForShutdown();
        }
        List<PrepareForShutdownListener> list = this.proxyInvocationHandlerPrepareForShutdownListenerList;
        synchronized (list) {
            proxyPrepareForShutdownFutures = this.getPrepareForShutdownFutures(this.proxyInvocationHandlerPrepareForShutdownListenerList);
        }
        this.callPrepareForShutdownListeners(proxyPrepareForShutdownFutures);
        if (this.messageTrackerPrepareForShutdownListener != null) {
            this.messageTrackerPrepareForShutdownListener.prepareForShutdown();
        }
        list = this.prepareForShutdownListenerList;
        synchronized (list) {
            proxyPrepareForShutdownFutures = this.getPrepareForShutdownFutures(this.prepareForShutdownListenerList);
        }
        this.callPrepareForShutdownListeners(proxyPrepareForShutdownFutures);
    }

    private Collection<CompletableFuture<Void>> getPrepareForShutdownFutures(List<PrepareForShutdownListener> listeners) {
        return listeners.stream().map(listener -> CompletableFuture.runAsync(listener::prepareForShutdown)).collect(Collectors.toList());
    }

    private void callPrepareForShutdownListeners(Collection<CompletableFuture<Void>> prepareForShutdownFutures) throws InterruptedException {
        try {
            CompletableFuture.allOf(prepareForShutdownFutures.toArray(new CompletableFuture[prepareForShutdownFutures.size()])).get(this.prepareForShutdownTimeoutSec, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.error("Interrupted while waiting for joynr message queue to drain.");
            throw e;
        }
        catch (Exception e) {
            logger.error("Exception occurred while preparing shutdown.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.hivemqMqttShutdownListener != null) {
            this.hivemqMqttShutdownListener.shutdown();
        }
        List<ShutdownListener> list = this.proxyInvocationHandlerShutdownListenerList;
        synchronized (list) {
            this.callShutdownListeners(this.proxyInvocationHandlerShutdownListenerList);
        }
        if (this.messageTrackerShutdownListener != null) {
            this.messageTrackerShutdownListener.shutdown();
        }
        list = this.shutdownListenerList;
        synchronized (list) {
            this.callShutdownListeners(this.shutdownListenerList);
        }
    }

    private void callShutdownListeners(List<ShutdownListener> listeners) {
        listeners.forEach(shutdownListener -> {
            logger.trace("Shutting down {}", shutdownListener);
            try {
                shutdownListener.shutdown();
            }
            catch (Exception e) {
                logger.error("Error shutting down {}:", shutdownListener, (Object)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(PrepareForShutdownListener listener) {
        List<PrepareForShutdownListener> list = this.prepareForShutdownListenerList;
        synchronized (list) {
            this.prepareForShutdownListenerList.remove(listener);
            logger.trace("Removed ShutdownListener, #ShutdownListeners: {}", (Object)this.shutdownListenerList.size());
        }
    }
}

