/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.routing;

import io.joynr.messaging.routing.TimedDelayed;
import java.util.HashSet;
import java.util.Set;
import joynr.ImmutableMessage;

public class DelayableImmutableMessage
extends TimedDelayed {
    private final ImmutableMessage message;
    private Set<String> recipients;
    private int retriesCount = 0;

    DelayableImmutableMessage(ImmutableMessage message, long delayForMs, Set<String> recipients) {
        super(delayForMs);
        this.message = message;
        this.recipients = recipients;
    }

    public DelayableImmutableMessage(ImmutableMessage message, long delayMs, Set<String> recipients, int retriesCount) {
        this(message, delayMs, recipients);
        this.setRetriesCount(retriesCount);
    }

    public ImmutableMessage getMessage() {
        return this.message;
    }

    public Set<String> getRecipients() {
        return this.recipients != null ? new HashSet<String>(this.recipients) : null;
    }

    public int getRetriesCount() {
        return this.retriesCount;
    }

    public void setRetriesCount(int retriesCount) {
        this.retriesCount = retriesCount;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + this.retriesCount;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DelayableImmutableMessage other = (DelayableImmutableMessage)obj;
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        return this.retriesCount == other.retriesCount;
    }
}

