/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.common;

import com.google.inject.Provides;
import com.google.inject.name.Named;
import io.joynr.guice.PropertyLoadingModule;
import io.joynr.messaging.MessagingPropertiesPersistence;
import io.joynr.runtime.PropertyLoader;
import java.io.File;
import java.util.Properties;

public class JoynrPropertiesModule
extends PropertyLoadingModule {
    public static final String PATTERN_DOESNT_START_WITH_JOYNAPP = "^(?!joynrapp).*$";
    static final String PATTERN_STARTS_WITH_JOYN = "^(javax)|(joynr)|(JOYNR).*$";

    public JoynrPropertiesModule(Properties customProperties) {
        super(new Properties[0]);
        Properties defaultMessagingProperties = PropertyLoader.loadProperties("defaultMessaging.properties");
        Properties envPropertiesAll = new Properties();
        envPropertiesAll.putAll(System.getenv());
        Properties joynrEnvProperties = PropertyLoader.getPropertiesWithPattern(envPropertiesAll, PATTERN_STARTS_WITH_JOYN);
        Properties systemProperties = PropertyLoader.getPropertiesWithPattern(System.getProperties(), PATTERN_DOESNT_START_WITH_JOYNAPP);
        String persistenceFileName = this.getProperty("joynr.messaging.persistence_file", "joynr.properties", new Properties[]{defaultMessagingProperties, customProperties, joynrEnvProperties, systemProperties});
        File persistencePropertiesFile = new File(persistenceFileName);
        MessagingPropertiesPersistence storage = new MessagingPropertiesPersistence(persistencePropertiesFile);
        this.mergeProperties(new Properties[]{defaultMessagingProperties, storage.getPersistedProperties(), customProperties, joynrEnvProperties, systemProperties});
    }

    @Provides
    @Named(value="joynr.properties")
    Properties provideProperties() {
        return this.properties;
    }
}

