/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.sender;

import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.messaging.routing.MessageRouter;
import io.joynr.messaging.sender.MessageSender;
import io.joynr.smrf.EncodingException;
import io.joynr.smrf.UnsuppportedVersionException;
import java.util.ArrayList;
import java.util.List;
import joynr.ImmutableMessage;
import joynr.MutableMessage;

public abstract class AbstractMessageSender
implements MessageSender {
    private MessageRouter messageRouter;
    private String replyToAddress = null;
    private List<MutableMessage> noReplyToAddressQueue = new ArrayList<MutableMessage>();

    protected AbstractMessageSender(MessageRouter messageRouter) {
        this.messageRouter = messageRouter;
    }

    @Override
    public synchronized void sendMessage(MutableMessage message) {
        boolean needsReplyToAddress = this.needsReplyToAddress(message);
        if (this.replyToAddress == null && needsReplyToAddress) {
            this.noReplyToAddressQueue.add(message);
        } else {
            if (needsReplyToAddress) {
                message.setReplyTo(this.replyToAddress);
            }
            this.routeMutableMessage(message);
        }
    }

    private boolean needsReplyToAddress(MutableMessage message) {
        String msgType = message.getType();
        boolean noReplyTo = message.getReplyTo() == null;
        boolean msgTypeNeedsReplyTo = msgType.equals("rq") || msgType.equals("arq") || msgType.equals("brq") || msgType.equals("mrq");
        return noReplyTo && msgTypeNeedsReplyTo && !message.isLocalMessage();
    }

    protected synchronized void setReplyToAddress(String replyToAddress) {
        this.replyToAddress = replyToAddress;
        for (MutableMessage queuedMessage : this.noReplyToAddressQueue) {
            queuedMessage.setReplyTo(replyToAddress);
            this.routeMutableMessage(queuedMessage);
        }
        this.noReplyToAddressQueue.clear();
    }

    private void routeMutableMessage(MutableMessage mutableMessage) {
        ImmutableMessage immutableMessage;
        try {
            immutableMessage = mutableMessage.getImmutableMessage();
        }
        catch (EncodingException | UnsuppportedVersionException | SecurityException exception) {
            throw new JoynrRuntimeException(exception.getMessage());
        }
        this.messageRouter.route(immutableMessage);
    }
}

