/*
 * Decompiled with CFR 0.152.
 */
package joynr;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.common.base.Charsets;
import io.joynr.smrf.EncodingException;
import io.joynr.smrf.MessageDeserializer;
import io.joynr.smrf.MessageDeserializerImpl;
import io.joynr.smrf.UnsuppportedVersionException;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import joynr.Message;

public class ImmutableMessage
extends Message {
    private transient boolean receivedFromGlobal;
    private final MessageDeserializer messageDeserializer;
    private final byte[] serializedMessage;
    private transient Map<String, Serializable> context = new HashMap<String, Serializable>();
    private ObjectMapper objectMapper = null;
    public static final String DUMMY_CREATOR_USER_ID = "creatorUserId";

    public ImmutableMessage(byte[] serializedMessage) throws EncodingException, UnsuppportedVersionException {
        this.serializedMessage = (byte[])serializedMessage.clone();
        this.messageDeserializer = new MessageDeserializerImpl(this.serializedMessage);
    }

    @JsonIgnore
    public byte[] getSerializedMessage() {
        return (byte[])this.serializedMessage.clone();
    }

    public long getTtlMs() {
        return this.messageDeserializer.getTtlMs();
    }

    public boolean isTtlAbsolute() {
        return this.messageDeserializer.isTtlAbsolute();
    }

    public String getSender() {
        return this.messageDeserializer.getSender();
    }

    public String getRecipient() {
        return this.messageDeserializer.getRecipient();
    }

    public String getReplyTo() {
        return this.messageDeserializer.getHeader("re");
    }

    public String getType() {
        return this.messageDeserializer.getHeader("t");
    }

    public String getEffort() {
        return this.messageDeserializer.getHeader("ef");
    }

    public String getCreatorUserId() {
        return DUMMY_CREATOR_USER_ID;
    }

    public byte[] getUnencryptedBody() throws EncodingException {
        return this.messageDeserializer.getUnencryptedBody();
    }

    public Map<String, String> getHeaders() {
        return this.messageDeserializer.getHeaders();
    }

    public Map<String, String> getCustomHeaders() {
        HashMap<String, String> customHeaders = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.getHeaders().entrySet()) {
            if (!entry.getKey().startsWith("c-")) continue;
            String key = entry.getKey().replaceFirst("^c-", "");
            customHeaders.put(key, entry.getValue());
        }
        return customHeaders;
    }

    public void setContext(HashMap<String, Serializable> context) {
        this.context = context;
    }

    public Map<String, Serializable> getContext() {
        return this.context;
    }

    public void setReceivedFromGlobal(boolean receivedFromGlobal) {
        this.receivedFromGlobal = receivedFromGlobal;
    }

    public boolean isReceivedFromGlobal() {
        return this.receivedFromGlobal;
    }

    public String getId() {
        return this.messageDeserializer.getHeader("id");
    }

    public boolean isEncrypted() {
        return this.messageDeserializer.isEncrypted();
    }

    public boolean isSigned() {
        return this.messageDeserializer.isSigned();
    }

    public boolean isCompressed() {
        return this.messageDeserializer.isCompressed();
    }

    @JsonIgnore
    public int getMessageSize() {
        return this.messageDeserializer.getMessageSize();
    }

    public String toLogMessage() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
            SimpleModule module = new SimpleModule();
            module.addSerializer(byte[].class, (JsonSerializer)new PayloadSerializer(byte[].class));
            this.objectMapper.registerModule((Module)module);
        }
        try {
            return this.objectMapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            return "";
        }
    }

    public String toString() {
        return this.toLogMessage();
    }

    public boolean isReply() {
        String messageType = this.getType();
        return "rp".equals(messageType) || "srp".equals(messageType);
    }

    private static class PayloadSerializer
    extends StdSerializer<byte[]> {
        private static final long serialVersionUID = 1L;

        protected PayloadSerializer(Class<byte[]> t) {
            super(t);
        }

        public void serialize(byte[] value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(new String(value, Charsets.UTF_8));
        }
    }
}

