/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.util;

import io.joynr.smrf.EncodingException;
import io.joynr.smrf.UnsuppportedVersionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import joynr.ImmutableMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utilities {
    private static final Logger logger = LoggerFactory.getLogger(Utilities.class);

    public static Object[] toArray(Object ... args) {
        return args;
    }

    public static List<String> splitJson(String combinedJsonString) {
        ArrayList<String> result = new ArrayList<String>();
        int numberOfOpeningBraces = 0;
        boolean isInsideString = false;
        StringBuilder jsonBuffer = new StringBuilder();
        for (int i = 0; i < combinedJsonString.length(); ++i) {
            char c = combinedJsonString.charAt(i);
            if (c == '\"' && i > 0 && combinedJsonString.charAt(i - 1) != '\\') {
                boolean bl = isInsideString = !isInsideString;
            }
            if (c == '{' && !isInsideString) {
                ++numberOfOpeningBraces;
            } else if (c == '}' && !isInsideString) {
                --numberOfOpeningBraces;
            }
            jsonBuffer.append(c);
            if (numberOfOpeningBraces != 0 || jsonBuffer.length() == 0) continue;
            if (jsonBuffer.toString().charAt(0) == '{') {
                result.add(jsonBuffer.toString());
            }
            jsonBuffer.setLength(0);
        }
        return result;
    }

    public static List<ImmutableMessage> splitSMRF(byte[] combinedSMRFMessages) throws EncodingException, UnsuppportedVersionException {
        ArrayList<ImmutableMessage> result = new ArrayList<ImmutableMessage>();
        byte[] remainingData = combinedSMRFMessages;
        while (remainingData.length > 0) {
            ImmutableMessage currentMessage = new ImmutableMessage(remainingData);
            int currentMessageSize = currentMessage.getMessageSize();
            if (currentMessageSize <= 0) {
                logger.error("One message in a SMRF message sequence had a size <= 0. Dropping remaining messages.");
                break;
            }
            remainingData = Arrays.copyOfRange(remainingData, currentMessageSize, remainingData.length);
            result.add(currentMessage);
        }
        return result;
    }

    public static boolean isSessionEncodedInUrl(String encodedUrl, String sessionIdName) {
        int sessionIdIndex = encodedUrl.indexOf(Utilities.getSessionIdSubstring(sessionIdName));
        return sessionIdIndex >= 0;
    }

    public static String getUrlWithoutSessionId(String url, String sessionIdName) {
        if (Utilities.isSessionEncodedInUrl(url, sessionIdName)) {
            return url.substring(0, url.indexOf(Utilities.getSessionIdSubstring(sessionIdName)));
        }
        return url;
    }

    public static String getSessionId(String url, String sessionIdName) {
        String sessionIdSubstring = Utilities.getSessionIdSubstring(sessionIdName);
        String sessionId = url.substring(url.indexOf(sessionIdSubstring) + sessionIdSubstring.length());
        if (sessionId.endsWith("/")) {
            sessionId = sessionId.substring(0, sessionId.length() - 1);
        }
        return sessionId;
    }

    private static String getSessionIdSubstring(String sessionIdName) {
        return ";" + sessionIdName + "=";
    }

    public static String getSessionEncodedUrl(String url, String sessionIdName, String sessionId) {
        return url + Utilities.getSessionIdSubstring(sessionIdName) + sessionId;
    }
}

