/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.routing;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.messaging.persistence.MessagePersister;
import io.joynr.messaging.routing.DelayableImmutableMessage;
import java.util.Set;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageQueue {
    private static final Logger logger = LoggerFactory.getLogger(MessageQueue.class);
    public static final String MESSAGE_QUEUE_ID = "io.joynr.messaging.queue.id";
    public static final String PROPERTY_MESSAGE_QUEUE_SHUTDOWN_MAX_TIMEOUT = "io.joynr.messaging.queue.shutdown.timeout";
    private DelayQueue<DelayableImmutableMessage> delayableImmutableMessages;
    private long shutdownTimeoutMs;
    private final String messageQueueId;
    private final MessagePersister messagePersister;

    @Inject
    public MessageQueue(DelayQueue<DelayableImmutableMessage> delayableImmutableMessages, MaxTimeoutHolder maxTimeoutHolder, @Named(value="io.joynr.messaging.queue.id") String messageQueueId, MessagePersister messagePersister) {
        this.delayableImmutableMessages = delayableImmutableMessages;
        this.shutdownTimeoutMs = maxTimeoutHolder.getTimeout();
        this.messageQueueId = messageQueueId;
        this.messagePersister = messagePersister;
        this.fetchAndQueuePersistedMessages(delayableImmutableMessages, messageQueueId);
    }

    private void fetchAndQueuePersistedMessages(DelayQueue<DelayableImmutableMessage> delayableImmutableMessages, String messageQueueId) {
        Set<DelayableImmutableMessage> persistedFromLastRun = this.messagePersister.fetchAll(messageQueueId);
        if (persistedFromLastRun != null) {
            persistedFromLastRun.forEach(delayableImmutableMessages::put);
        }
    }

    void waitForQueueToDrain() {
        int remainingMessages = this.delayableImmutableMessages.size();
        logger.info("joynr message queue stopping. Contains {} remaining messages.", (Object)remainingMessages);
        if (remainingMessages > 0) {
            long shutdownStart = System.currentTimeMillis();
            while (System.currentTimeMillis() - shutdownStart < this.shutdownTimeoutMs && this.delayableImmutableMessages.size() != 0) {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException e) {
                    logger.error("Interrupted while waiting for joynr message queue to drain.");
                    e.printStackTrace();
                }
            }
        }
        if ((remainingMessages = this.delayableImmutableMessages.size()) == 0) {
            logger.info("joynr message queue successfully emptied.");
        } else {
            logger.info("joynr message queue still contained " + remainingMessages + " messages at shutdown.");
        }
    }

    public void put(DelayableImmutableMessage delayableImmutableMessage) {
        if (this.messagePersister.persist(this.messageQueueId, delayableImmutableMessage)) {
            logger.trace("Message {} was persisted for messageQueueId {}", (Object)delayableImmutableMessage.getMessage(), (Object)this.messageQueueId);
        } else {
            logger.trace("Message {} was not persisted for messageQueueId {}", (Object)delayableImmutableMessage.getMessage(), (Object)this.messageQueueId);
        }
        this.delayableImmutableMessages.put(delayableImmutableMessage);
    }

    public DelayableImmutableMessage poll(long timeout, TimeUnit unit) throws InterruptedException {
        DelayableImmutableMessage message = (DelayableImmutableMessage)this.delayableImmutableMessages.poll(timeout, unit);
        if (message != null) {
            this.messagePersister.remove(this.messageQueueId, message);
        }
        return message;
    }

    public static class MaxTimeoutHolder {
        @Inject(optional=true)
        @Named(value="io.joynr.messaging.queue.shutdown.timeout")
        private Long timeout = 5000L;

        public long getTimeout() {
            return this.timeout;
        }
    }
}

