/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.common;

import java.text.SimpleDateFormat;

public class ExpiryDate {
    private long value;
    private long relativeTtl;
    private long creationTime;

    public static ExpiryDate fromRelativeTtl(long relativeTtl) {
        long expiryDate;
        long creationTime = System.currentTimeMillis();
        try {
            expiryDate = Math.addExact(creationTime, relativeTtl);
        }
        catch (ArithmeticException exception) {
            expiryDate = Long.MAX_VALUE;
        }
        if (expiryDate > 0x1FFFFFFFFFFFFFL) {
            expiryDate = 0x1FFFFFFFFFFFFFL;
        }
        return new ExpiryDate(relativeTtl, expiryDate, creationTime);
    }

    public static ExpiryDate fromAbsolute(long expiryDate) {
        long relativeTtl;
        long creationTime = System.currentTimeMillis();
        try {
            relativeTtl = Math.subtractExact(expiryDate, creationTime);
        }
        catch (ArithmeticException exception) {
            relativeTtl = Long.MIN_VALUE;
        }
        return new ExpiryDate(relativeTtl, expiryDate, creationTime);
    }

    private ExpiryDate(long relativeTtl, long expiryDate, long creationTime) {
        this.relativeTtl = relativeTtl;
        this.value = expiryDate;
        this.creationTime = creationTime;
    }

    public long getValue() {
        return this.value;
    }

    public long getRelativeTtl() {
        return this.relativeTtl;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String toString() {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("dd/MM HH:mm:ss:sss");
        return "ExpiryDate in ms: " + this.value + " ExpiryDate: " + dateFormatter.format(this.value) + " relativeTtl:" + this.relativeTtl + " creationTime: " + dateFormatter.format(this.creationTime);
    }
}

