/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.runtime;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.joynr.runtime.ShutdownListener;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ShutdownNotifier {
    private static final Logger logger = LoggerFactory.getLogger(ShutdownNotifier.class);
    private static final String PROPERTY_PREPARE_FOR_SHUTDOWN_TIMEOUT = "joynr.runtime.prepareforshutdowntimeout";
    private List<ShutdownListener> shutdownListeners = new LinkedList<ShutdownListener>();
    @Inject(optional=true)
    @Named(value="joynr.runtime.prepareforshutdowntimeout")
    private int prepareForShutdownTimeoutSec = 5;

    public void registerForShutdown(ShutdownListener shutdownListener) {
        this.shutdownListeners.add(0, shutdownListener);
    }

    public void registerToBeShutdownAsLast(ShutdownListener shutdownListener) {
        this.shutdownListeners.add(shutdownListener);
    }

    public void prepareForShutdown() {
        Collection prepareShutdownFutures = this.shutdownListeners.stream().map(shutdownListener -> CompletableFuture.runAsync(() -> shutdownListener.prepareForShutdown())).collect(Collectors.toList());
        try {
            CompletableFuture.allOf(prepareShutdownFutures.toArray(new CompletableFuture[prepareShutdownFutures.size()])).get(this.prepareForShutdownTimeoutSec, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.error("Exception occurred while preparing shutdown.", (Throwable)e);
        }
    }

    public void shutdown() {
        this.shutdownListeners.forEach(shutdownListener -> {
            logger.trace("shutting down {}", shutdownListener);
            try {
                shutdownListener.shutdown();
            }
            catch (Exception e) {
                logger.error("error shutting down {}: {}", shutdownListener, (Object)e.getMessage());
            }
        });
    }
}

