/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging;

import io.joynr.runtime.PropertyLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagingPropertiesPersistence {
    private static final Logger LOG = LoggerFactory.getLogger(MessagingPropertiesPersistence.class);
    private File persistenceFile;
    private Properties storage;

    public MessagingPropertiesPersistence(File persistenceFile) {
        this.persistenceFile = persistenceFile;
        this.makeDirectories(persistenceFile);
        this.storage = PropertyLoader.loadProperties(persistenceFile);
        this.generateIfAbsent("joynr.messaging.channelid");
        this.generateIfAbsent("joynr.messaging.receiverid");
        this.generateIfAbsent("io.joynr.messaging.queue.id");
        this.persistProperties();
    }

    public Properties getPersistedProperties() {
        return this.storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistProperties() {
        FileOutputStream fileOutputStream = null;
        try {
            boolean created;
            File parentDirectory = this.persistenceFile.getParentFile();
            if (parentDirectory != null && !parentDirectory.exists() && !parentDirectory.mkdirs()) {
                throw new IllegalStateException("Could not create parent directory: " + parentDirectory);
            }
            if (!this.persistenceFile.exists() && !(created = this.persistenceFile.createNewFile())) {
                throw new IllegalStateException("Could not create persistenceFile: " + this.persistenceFile);
            }
            fileOutputStream = new FileOutputStream(this.persistenceFile);
            this.storage.store(fileOutputStream, null);
        }
        catch (IOException e1) {
            LOG.error("Couldn't write properties file {}", (Object)this.persistenceFile.getPath(), (Object)e1);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void makeDirectories(File persistenceFile) {
        boolean madeDirs;
        File parentFile = persistenceFile.getParentFile();
        if (parentFile != null && !parentFile.exists() && !(madeDirs = parentFile.mkdirs())) {
            throw new IllegalStateException("Couldn't create dir: " + parentFile);
        }
    }

    private void generateIfAbsent(String propertyName) {
        if (!this.storage.containsKey(propertyName)) {
            String propertyValue = UUID.randomUUID().toString();
            this.storage.put(propertyName, propertyValue);
        }
    }
}

