/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.joynr.messaging.IMessagingSkeleton;
import io.joynr.runtime.ShutdownListener;
import io.joynr.runtime.ShutdownNotifier;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import joynr.system.RoutingTypes.Address;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MessagingSkeletonFactory
implements ShutdownListener {
    private static final Logger logger = LoggerFactory.getLogger(MessagingSkeletonFactory.class);
    public static final String MIDDLEWARE_MESSAGING_SKELETONS = "MIDDLEWARE_MESSAGING_SKELETONS";
    private Map<Class<? extends Address>, IMessagingSkeleton> messagingSkeletons;
    private ScheduledExecutorService scheduler;
    private boolean started;

    @Inject
    public MessagingSkeletonFactory(@Named(value="MIDDLEWARE_MESSAGING_SKELETONS") Map<Class<? extends Address>, IMessagingSkeleton> messagingSkeletons, @Named(value="io.joynr.messaging.scheduledthreadpool") ScheduledExecutorService scheduler, ShutdownNotifier shutdownNotifier) {
        this.messagingSkeletons = messagingSkeletons;
        this.scheduler = scheduler;
        shutdownNotifier.registerForShutdown(this);
    }

    public synchronized void start() {
        if (!this.started) {
            for (final IMessagingSkeleton messagingSkeleton : this.messagingSkeletons.values()) {
                this.scheduler.schedule(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            messagingSkeleton.init();
                        }
                        catch (Exception e) {
                            logger.error("unable to start skeleton: {}. Reason: {}", (Object)messagingSkeleton.getClass().getSimpleName(), (Object)e.getMessage());
                        }
                    }
                }, 0L, TimeUnit.MILLISECONDS);
            }
        } else {
            logger.info("Already started - skipping.");
        }
        this.started = true;
    }

    @Override
    public void shutdown() {
        for (IMessagingSkeleton messagingSkeleton : this.messagingSkeletons.values()) {
            messagingSkeleton.shutdown();
        }
    }

    @CheckForNull
    public IMessagingSkeleton getSkeleton(Address address) {
        if (address != null) {
            return this.messagingSkeletons.get(address.getClass());
        }
        return null;
    }
}

