/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.routing;

import io.joynr.messaging.routing.TimedDelayed;
import java.util.Set;
import joynr.ImmutableMessage;
import joynr.system.RoutingTypes.Address;

public class DelayableImmutableMessage
extends TimedDelayed {
    private final ImmutableMessage message;
    private final Set<Address> destinationAddresses;
    private int retriesCount = 0;

    DelayableImmutableMessage(ImmutableMessage message, long delayForMs, Set<Address> destinationAddresses) {
        super(delayForMs);
        this.message = message;
        this.destinationAddresses = destinationAddresses;
    }

    public DelayableImmutableMessage(ImmutableMessage message, long delayMs, Set<Address> destinationAddresses, int retriesCount) {
        this(message, delayMs, destinationAddresses);
        this.setRetriesCount(retriesCount);
    }

    public ImmutableMessage getMessage() {
        return this.message;
    }

    public Set<Address> getDestinationAddresses() {
        return this.destinationAddresses;
    }

    public int getRetriesCount() {
        return this.retriesCount;
    }

    public void setRetriesCount(int retriesCount) {
        this.retriesCount = retriesCount;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + this.retriesCount;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DelayableImmutableMessage other = (DelayableImmutableMessage)obj;
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        return this.retriesCount == other.retriesCount;
    }
}

