/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.exceptions.JoynrIllegalStateException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GbidArrayFactory {
    private static final Logger logger = LoggerFactory.getLogger(GbidArrayFactory.class);
    private String[] gbidArray;

    @Inject
    public GbidArrayFactory(@Named(value="joynr.messaging.gbids") String gbids) {
        this.gbidArray = (String[])Arrays.stream(gbids.split(",")).map(a -> a.trim()).toArray(String[]::new);
        if (this.gbidArray.length == 0) {
            logger.error("At least one GBID has to be defined!");
            throw new JoynrIllegalStateException("At least one GBID has to be defined!");
        }
        if (Arrays.stream(this.gbidArray).anyMatch(gbid -> gbid.isEmpty())) {
            logger.error("GBID must not be empty: {}!", (Object)gbids);
            throw new JoynrIllegalStateException("GBID must not be empty: " + gbids + "!");
        }
    }

    public String[] create() {
        return (String[])this.gbidArray.clone();
    }
}

