/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.mqtt.hivemq.client;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.hivemq.client.mqtt.MqttClient;
import com.hivemq.client.mqtt.MqttClientExecutorConfig;
import com.hivemq.client.mqtt.MqttClientExecutorConfigBuilder;
import com.hivemq.client.mqtt.MqttClientSslConfigBuilder;
import com.hivemq.client.mqtt.lifecycle.MqttClientConnectedContext;
import com.hivemq.client.mqtt.lifecycle.MqttClientConnectedListener;
import com.hivemq.client.mqtt.lifecycle.MqttClientDisconnectedContext;
import com.hivemq.client.mqtt.lifecycle.MqttClientDisconnectedListener;
import com.hivemq.client.mqtt.mqtt5.Mqtt5ClientBuilder;
import com.hivemq.client.mqtt.mqtt5.Mqtt5RxClient;
import com.hivemq.client.mqtt.mqtt5.message.auth.Mqtt5SimpleAuthBuilder;
import io.joynr.exceptions.JoynrIllegalStateException;
import io.joynr.messaging.mqtt.JoynrMqttClient;
import io.joynr.messaging.mqtt.MqttClientFactory;
import io.joynr.messaging.mqtt.MqttClientIdProvider;
import io.joynr.messaging.mqtt.hivemq.client.HivemqMqttClient;
import io.joynr.runtime.ShutdownListener;
import io.joynr.runtime.ShutdownNotifier;
import io.joynr.statusmetrics.ConnectionStatusMetrics;
import io.joynr.statusmetrics.ConnectionStatusMetricsImpl;
import io.joynr.statusmetrics.JoynrStatusMetricsReceiver;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HivemqMqttClientFactory
implements MqttClientFactory,
ShutdownListener {
    private static final Logger logger = LoggerFactory.getLogger(HivemqMqttClientFactory.class);
    private HashMap<String, JoynrMqttClient> receivingMqttClients;
    private HashMap<String, JoynrMqttClient> sendingMqttClients;
    private final boolean separateConnections;
    private final MqttClientIdProvider mqttClientIdProvider;
    private final ScheduledExecutorService scheduledExecutorService;
    private HashMap<String, String> mqttGbidToBrokerUriMap;
    private HashMap<String, Integer> mqttGbidToKeepAliveTimerSecMap;
    private HashMap<String, Integer> mqttGbidToConnectionTimeoutSecMap;
    private final boolean cleanSession;
    private final JoynrStatusMetricsReceiver joynrStatusMetricsReceiver;
    @Inject(optional=true)
    @Named(value="joynr.messaging.mqtt.ssl.keystore")
    private String keyStorePath;
    @Inject(optional=true)
    @Named(value="joynr.messaging.mqtt.ssl.truststore")
    private String trustStorePath;
    @Inject(optional=true)
    @Named(value="joynr.messaging.mqtt.ssl.keystoretype")
    private String keyStoreType;
    @Inject(optional=true)
    @Named(value="joynr.messaging.mqtt.ssl.truststoretype")
    private String trustStoreType;
    @Inject(optional=true)
    @Named(value="joynr.messaging.mqtt.ssl.keystorepassword")
    private String keyStorePWD;
    @Inject(optional=true)
    @Named(value="joynr.messaging.mqtt.ssl.truststorepassword")
    private String trustStorePWD;
    @Inject(optional=true)
    @Named(value="joynr.messaging.mqtt.username")
    private String username = "";
    @Inject(optional=true)
    @Named(value="joynr.messaging.mqtt.password")
    private String password = "";
    @Inject(optional=true)
    @Named(value="joynr.messaging.mqtt.disablehostnameverification")
    private Boolean disableHostnameVerification = false;
    @Inject
    @Named(value="joynr.internal.messaging.mqtt.ssl.ciphersuiteList")
    private List<String> cipherSuiteList;
    @Inject
    @Named(value="joynr.messaging.mqtt.reconnect.sleepms")
    private int reconnectDelayMs;

    @Inject
    public HivemqMqttClientFactory(@Named(value="joynr.messaging.mqtt.separateconnections") boolean separateConnections, @Named(value="joynr.internal.messaging.mqtt.gbidtobrokerurimap") HashMap<String, String> mqttGbidToBrokerUriMap, @Named(value="joynr.internal.messaging.mqtt.gbidtokeepalivetimersecmap") HashMap<String, Integer> mqttGbidToKeepAliveTimerSecMap, @Named(value="joynr.internal.messaging.mqtt.gbidtoconnectiontimeoutsecmap") HashMap<String, Integer> mqttGbidToConnectionTimeoutSecMap, @Named(value="joynr.messaging.mqtt.cleansession") boolean cleanSession, @Named(value="io.joynr.messaging.scheduledthreadpool") ScheduledExecutorService scheduledExecutorService, MqttClientIdProvider mqttClientIdProvider, JoynrStatusMetricsReceiver joynrStatusMetricsReceiver, ShutdownNotifier shutdownNotifier) {
        this.mqttGbidToBrokerUriMap = mqttGbidToBrokerUriMap;
        this.mqttGbidToKeepAliveTimerSecMap = mqttGbidToKeepAliveTimerSecMap;
        this.mqttGbidToConnectionTimeoutSecMap = mqttGbidToConnectionTimeoutSecMap;
        this.separateConnections = separateConnections;
        this.scheduledExecutorService = scheduledExecutorService;
        this.mqttClientIdProvider = mqttClientIdProvider;
        this.sendingMqttClients = new HashMap();
        this.receivingMqttClients = new HashMap();
        this.cleanSession = cleanSession;
        this.joynrStatusMetricsReceiver = joynrStatusMetricsReceiver;
        shutdownNotifier.registerForShutdown((ShutdownListener)this);
    }

    public synchronized JoynrMqttClient createSender(String gbid) {
        if (!this.sendingMqttClients.containsKey(gbid)) {
            if (this.separateConnections) {
                logger.info("Creating sender MQTT client for gbid {}", (Object)gbid);
                this.sendingMqttClients.put(gbid, this.createClient(gbid, this.mqttClientIdProvider.getClientId() + "Pub", false, true));
                logger.debug("Sender MQTT client for gbid {} now: {}", (Object)gbid, (Object)this.sendingMqttClients.get(gbid));
            } else {
                this.createCombinedClient(gbid);
            }
        }
        return this.sendingMqttClients.get(gbid);
    }

    public synchronized JoynrMqttClient createReceiver(String gbid) {
        if (!this.receivingMqttClients.containsKey(gbid)) {
            logger.info("Creating receiver MQTT client for gbid {}", (Object)gbid);
            if (this.separateConnections) {
                this.receivingMqttClients.put(gbid, this.createClient(gbid, this.mqttClientIdProvider.getClientId() + "Sub", true, false));
            } else {
                this.createCombinedClient(gbid);
            }
            logger.debug("Receiver MQTT client for gbid {} now: {}", (Object)gbid, (Object)this.receivingMqttClients.get(gbid));
        }
        return this.receivingMqttClients.get(gbid);
    }

    public synchronized void prepareForShutdown() {
        if (this.separateConnections) {
            for (JoynrMqttClient client : this.receivingMqttClients.values()) {
                client.shutdown();
            }
        }
    }

    public synchronized void shutdown() {
        logger.debug("shutdown invoked");
        if (this.separateConnections) {
            for (JoynrMqttClient client : this.receivingMqttClients.values()) {
                if (client.isShutdown()) continue;
                client.shutdown();
            }
        }
        for (JoynrMqttClient client : this.sendingMqttClients.values()) {
            client.shutdown();
        }
        Schedulers.shutdown();
        logger.debug("shutdown finished");
    }

    private void createCombinedClient(String gbid) {
        this.sendingMqttClients.put(gbid, this.createClient(gbid, this.mqttClientIdProvider.getClientId(), true, true));
        this.receivingMqttClients.put(gbid, this.sendingMqttClients.get(gbid));
    }

    private JoynrMqttClient createClient(String gbid, String clientId, boolean isReceiver, boolean isSender) {
        URI serverUri;
        try {
            serverUri = new URI(this.mqttGbidToBrokerUriMap.get(gbid));
        }
        catch (URISyntaxException e) {
            throw new JoynrIllegalStateException("Invalid MQTT broker URI: " + this.mqttGbidToBrokerUriMap.get(gbid), (Exception)e);
        }
        logger.info("Creating MQTT client for gbid \"{}\", uri {}, clientId {}", new Object[]{gbid, serverUri, clientId});
        MqttClientExecutorConfig executorConfig = ((MqttClientExecutorConfigBuilder)((MqttClientExecutorConfigBuilder)MqttClientExecutorConfig.builder().nettyExecutor((Executor)this.scheduledExecutorService)).applicationScheduler(Schedulers.from((Executor)this.scheduledExecutorService))).build();
        ConnectionStatusMetricsImpl connectionStatusMetrics = new ConnectionStatusMetricsImpl();
        connectionStatusMetrics.setGbid(gbid);
        connectionStatusMetrics.setSender(isSender);
        connectionStatusMetrics.setReceiver(isReceiver);
        connectionStatusMetrics.setUrl(this.mqttGbidToBrokerUriMap.get(gbid));
        this.joynrStatusMetricsReceiver.addConnectionStatusMetrics((ConnectionStatusMetrics)connectionStatusMetrics);
        ResubscribeHandler resubscribeHandler = new ResubscribeHandler(connectionStatusMetrics);
        DisconnectedListener disconnectedListener = new DisconnectedListener(connectionStatusMetrics);
        Mqtt5ClientBuilder clientBuilder = (Mqtt5ClientBuilder)((Mqtt5ClientBuilder)((Mqtt5ClientBuilder)((Mqtt5ClientBuilder)((Mqtt5ClientBuilder)((Mqtt5ClientBuilder)((Mqtt5ClientBuilder)MqttClient.builder().useMqttVersion5().identifier(clientId)).serverHost(serverUri.getHost())).serverPort(serverUri.getPort())).automaticReconnectWithDefaultConfig()).addConnectedListener((MqttClientConnectedListener)resubscribeHandler)).addDisconnectedListener((MqttClientDisconnectedListener)disconnectedListener)).executorConfig(executorConfig);
        if (serverUri.getScheme().equals("ssl") || serverUri.getScheme().equals("tls") || serverUri.getScheme().equals("mqtts")) {
            clientBuilder.sslWithDefaultConfig();
            this.setupSslConfig(clientBuilder);
        }
        if (this.username != null && !this.username.isEmpty() && this.password != null && !this.password.isEmpty()) {
            ((Mqtt5SimpleAuthBuilder.Nested.Complete)((Mqtt5SimpleAuthBuilder.Nested.Complete)clientBuilder.simpleAuth().username(this.username)).password(this.password.getBytes(StandardCharsets.UTF_8))).applySimpleAuth();
        }
        Mqtt5RxClient client = clientBuilder.buildRx();
        HivemqMqttClient result = new HivemqMqttClient(client, this.mqttGbidToKeepAliveTimerSecMap.get(gbid), this.cleanSession, this.mqttGbidToConnectionTimeoutSecMap.get(gbid), this.reconnectDelayMs, isReceiver, isSender, gbid, connectionStatusMetrics);
        logger.info("Created MQTT client for gbid {}, uri {}, clientId {}: {}", new Object[]{gbid, serverUri, clientId, result.getClientInformationString()});
        resubscribeHandler.setClient(result);
        disconnectedListener.setClientInformationString(result.getClientInformationString());
        return result;
    }

    private void setupSslConfig(Mqtt5ClientBuilder clientBuilder) {
        MqttClientSslConfigBuilder.Nested sslConfig = clientBuilder.sslConfig();
        if (this.cipherSuiteList != null && this.cipherSuiteList.size() > 0) {
            for (String string : this.cipherSuiteList) {
                logger.debug("Using cipher suite {}.", (Object)string);
            }
            sslConfig.cipherSuites(this.cipherSuiteList);
        } else {
            List<String> cipherSuites = this.getEnabledCipherSuites();
            for (String cipherSuite : cipherSuites) {
                logger.debug("Using cipher suite {}.", (Object)cipherSuite);
            }
            sslConfig.cipherSuites(cipherSuites);
        }
        if (this.trustStorePath != null && this.trustStorePWD != null) {
            KeyStore trustStore = this.getKeystore(this.trustStorePath, this.trustStorePWD, this.trustStoreType);
            logger.info("Setting up trust manager with {} / {} (password omitted)", (Object)this.trustStorePath, (Object)this.trustStoreType);
            if (trustStore != null) {
                try {
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustManagerFactory.init(trustStore);
                    sslConfig.trustManagerFactory(trustManagerFactory);
                    if (this.disableHostnameVerification.booleanValue()) {
                        sslConfig.hostnameVerifier(new HostnameVerifier(){

                            @Override
                            public boolean verify(String hostname, SSLSession session) {
                                logger.info("Skipping regular hostname verification");
                                return true;
                            }
                        });
                        logger.info("Hostname verification disabled.");
                    }
                }
                catch (KeyStoreException | NoSuchAlgorithmException generalSecurityException) {
                    logger.error("Unable to create trust store factory:", (Throwable)generalSecurityException);
                }
            }
        }
        if (this.keyStorePath != null && this.keyStorePWD != null) {
            logger.info("Setting up key manager with {} / {} (password omitted)", (Object)this.keyStorePath, (Object)this.keyStoreType);
            KeyStore keyStore = this.getKeystore(this.keyStorePath, this.keyStorePWD, this.keyStoreType);
            if (keyStore != null) {
                try {
                    KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    keyManagerFactory.init(keyStore, this.keyStorePWD.toCharArray());
                    sslConfig.keyManagerFactory(keyManagerFactory);
                }
                catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException generalSecurityException) {
                    logger.error("Unable to create key manager factory:", (Throwable)generalSecurityException);
                }
            }
        }
        sslConfig.applySslConfig();
    }

    private List<String> getEnabledCipherSuites() {
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, null, null);
            SSLEngine sslEngine = context.createSSLEngine();
            return Arrays.asList(sslEngine.getEnabledCipherSuites());
        }
        catch (Exception e) {
            return Arrays.asList("TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384");
        }
    }

    private KeyStore getKeystore(String storePath, String storePassword, String storeType) {
        try {
            KeyStore keyStore = KeyStore.getInstance(storeType == null ? KeyStore.getDefaultType() : storeType);
            try (InputStream inputStream = this.getInputStream(storePath);){
                keyStore.load(inputStream, storePassword.toCharArray());
            }
            return keyStore;
        }
        catch (IOException | SecurityException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            logger.error("Unable to load keystore from {} / {} (password omitted):", new Object[]{storePath, storeType, e});
            return null;
        }
    }

    private InputStream getInputStream(String path) throws IOException {
        File file;
        InputStream result = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        if (result == null) {
            result = ClassLoader.getSystemClassLoader().getResourceAsStream(path);
        }
        if (result == null && (file = new File(path)).exists()) {
            result = new FileInputStream(file);
        }
        if (result == null) {
            try {
                URL url = new URL(path);
                result = url.openStream();
            }
            catch (MalformedURLException e) {
                logger.debug("Attempt to interpret {} as URL failed. Ignoring.", (Object)path);
            }
        }
        return result;
    }

    static class DisconnectedListener
    implements MqttClientDisconnectedListener {
        private String clientInformation;
        private ConnectionStatusMetricsImpl connectionStatusMetrics;

        DisconnectedListener(ConnectionStatusMetricsImpl connectionStatusMetrics) {
            this.connectionStatusMetrics = connectionStatusMetrics;
        }

        void setClientInformationString(String clientInformation) {
            this.clientInformation = clientInformation;
        }

        public void onDisconnected(MqttClientDisconnectedContext context) {
            logger.info("{}: HiveMQ MQTT client disconnected: source: {}", new Object[]{this.clientInformation, context.getSource(), context.getCause()});
            this.connectionStatusMetrics.setConnected(false);
            this.connectionStatusMetrics.increaseConnectionDrops();
        }
    }

    static class ResubscribeHandler
    implements MqttClientConnectedListener {
        private HivemqMqttClient client;
        private ConnectionStatusMetricsImpl connectionStatusMetrics;

        void setClient(HivemqMqttClient client) {
            this.client = client;
        }

        public ResubscribeHandler(ConnectionStatusMetricsImpl connectionStatusMetrics) {
            this.connectionStatusMetrics = connectionStatusMetrics;
        }

        public void onConnected(MqttClientConnectedContext context) {
            this.client.resubscribe();
            this.connectionStatusMetrics.setConnected(true);
        }
    }
}

