/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.mqtt.hivemq.client;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.joynr.messaging.mqtt.JoynrMqttClient;
import io.joynr.messaging.mqtt.JoynrMqttClientCreator;
import io.joynr.messaging.mqtt.MqttClientFactory;
import io.joynr.messaging.mqtt.MqttClientIdProvider;
import io.joynr.messaging.mqtt.MqttClientSignalService;
import io.joynr.runtime.PrepareForShutdownListener;
import io.joynr.runtime.ShutdownListener;
import io.joynr.runtime.ShutdownNotifier;
import io.reactivex.schedulers.Schedulers;
import java.util.HashMap;
import java.util.HashSet;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HivemqMqttClientFactory
implements MqttClientFactory,
ShutdownListener,
PrepareForShutdownListener,
MqttClientSignalService {
    private static final Logger logger = LoggerFactory.getLogger(HivemqMqttClientFactory.class);
    public static final String SENDER_PREFIX = "Pub";
    public static final String RECEIVER_PREFIX = "Sub";
    public static final String REPLY_RECEIVER_PREFIX = "SubReply";
    private final HashMap<String, JoynrMqttClient> receivingRequestClients;
    private final HashMap<String, JoynrMqttClient> receivingReplyClients;
    private final HashMap<String, JoynrMqttClient> sendingMqttClients;
    private final boolean separateConnections;
    private final MqttClientIdProvider mqttClientIdProvider;
    private final boolean separateReplyReceiver;
    private final JoynrMqttClientCreator clientCreator;
    private boolean canConnect;
    private final boolean sharedSubscriptions;

    @Inject
    public HivemqMqttClientFactory(@Named(value="joynr.messaging.mqtt.separateconnections") boolean separateConnections, MqttClientIdProvider mqttClientIdProvider, ShutdownNotifier shutdownNotifier, JoynrMqttClientCreator clientCreator, @Named(value="joynr.messaging.mqtt.connectonstart") boolean canConnect, @Named(value="joynr.messaging.separatereplyreceiver") boolean separateReplyReceiver, @Named(value="joynr.messaging.mqtt.enable.sharedsubscriptions") boolean sharedSubscriptions) {
        this.separateConnections = separateConnections;
        this.mqttClientIdProvider = mqttClientIdProvider;
        this.sendingMqttClients = new HashMap();
        this.receivingRequestClients = new HashMap();
        this.receivingReplyClients = new HashMap();
        this.clientCreator = clientCreator;
        this.separateReplyReceiver = separateReplyReceiver;
        this.canConnect = canConnect;
        this.sharedSubscriptions = sharedSubscriptions;
        shutdownNotifier.registerHivemqMqttShutdownListener((ShutdownListener)this);
        shutdownNotifier.registerHivemqMqttPrepareForShutdownListener((PrepareForShutdownListener)this);
    }

    public synchronized JoynrMqttClient createSender(String gbid) {
        JoynrMqttClient client = this.sendingMqttClients.get(gbid);
        if (client == null) {
            logger.info("Creating sender MQTT client for gbid {}", (Object)gbid);
            if (this.separateConnections) {
                this.sendingMqttClients.put(gbid, this.clientCreator.createClient(gbid, this.getSenderClientId(), false, true, false));
            } else {
                this.createCombinedClient(gbid);
            }
            logger.debug("Sender MQTT client for gbid {} now: {}", (Object)gbid, (Object)this.sendingMqttClients.get(gbid));
        }
        return this.sendingMqttClients.get(gbid);
    }

    public synchronized JoynrMqttClient createReceiver(String gbid) {
        JoynrMqttClient client = this.receivingRequestClients.get(gbid);
        if (client == null) {
            logger.info("Creating receiver MQTT client for gbid {}", (Object)gbid);
            if (this.separateConnections) {
                this.receivingRequestClients.put(gbid, this.clientCreator.createClient(gbid, this.getReceiverClientId(), true, false, !this.separateReplyReceiver));
            } else if (this.separateReplyReceiver && this.sharedSubscriptions) {
                logger.info("Receiver MQTT client for gbid {} will not handle incoming messages.", (Object)gbid);
                this.receivingRequestClients.put(gbid, this.clientCreator.createClient(gbid, this.getReceiverClientId(), true, false, false));
                logger.info("A separate client for receiving replies and sending messages will be created for gbid {}.", (Object)gbid);
                JoynrMqttClient replyReceiver = this.createReplyReceiver(gbid);
                this.sendingMqttClients.put(gbid, replyReceiver);
            } else {
                this.createCombinedClient(gbid);
            }
            logger.debug("Receiver MQTT client for gbid {} now: {}", (Object)gbid, (Object)this.receivingRequestClients.get(gbid));
        }
        return this.receivingRequestClients.get(gbid);
    }

    public synchronized JoynrMqttClient createReplyReceiver(String gbid) {
        if (!this.separateReplyReceiver) {
            return this.createReceiver(gbid);
        }
        JoynrMqttClient client = this.receivingReplyClients.get(gbid);
        if (client == null) {
            logger.info("Creating reply receiver MQTT client for gbid {}", (Object)gbid);
            this.receivingReplyClients.put(gbid, this.clientCreator.createClient(gbid, this.getReplyReceiverClientId(), true, !this.separateConnections && this.sharedSubscriptions, true));
            logger.debug("Reply Receiver MQTT client for gbid {} now: {}", (Object)gbid, (Object)this.receivingReplyClients.get(gbid));
        }
        return this.receivingReplyClients.get(gbid);
    }

    public synchronized void prepareForShutdown() {
        if (this.shouldShutdownReceivingRequestsClients()) {
            this.receivingRequestClients.values().forEach(JoynrMqttClient::shutdown);
        }
    }

    private boolean shouldShutdownReceivingRequestsClients() {
        return this.separateConnections || this.sharedSubscriptions && this.separateReplyReceiver;
    }

    public synchronized void shutdown() {
        logger.debug("shutdown invoked");
        this.stop();
        Stream.of(this.sendingMqttClients.values().stream(), this.receivingRequestClients.values().stream(), this.receivingReplyClients.values().stream()).flatMap(i -> i).distinct().forEach(JoynrMqttClient::shutdown);
        Schedulers.shutdown();
        logger.debug("shutdown finished");
    }

    public synchronized void start() {
        this.canConnect = true;
        Stream.of(this.sendingMqttClients.values().stream(), this.receivingRequestClients.values().stream(), this.receivingReplyClients.values().stream()).flatMap(i -> i).distinct().forEach(this::connectIfNotShuttingDown);
    }

    private void connectIfNotShuttingDown(JoynrMqttClient client) {
        if (!client.isShutdown()) {
            this.connect(client);
        }
    }

    public synchronized void connect(JoynrMqttClient client) {
        if (this.canConnect) {
            client.connect();
        }
    }

    public synchronized void stop() {
        if (!this.canConnect) {
            return;
        }
        this.canConnect = false;
        HashSet<JoynrMqttClient> clientsToDisconnect = new HashSet<JoynrMqttClient>(this.sendingMqttClients.values());
        if (this.separateConnections) {
            clientsToDisconnect.addAll(this.receivingRequestClients.values());
        }
        if (this.separateReplyReceiver) {
            clientsToDisconnect.addAll(this.receivingReplyClients.values());
        }
        clientsToDisconnect.forEach(JoynrMqttClient::disconnect);
    }

    private void createCombinedClient(String gbid) {
        this.sendingMqttClients.put(gbid, this.clientCreator.createClient(gbid, this.mqttClientIdProvider.getClientId(), true, true, !this.separateReplyReceiver));
        this.receivingRequestClients.put(gbid, this.sendingMqttClients.get(gbid));
    }

    private String getClientId(String suffix) {
        return this.mqttClientIdProvider.getClientId() + suffix;
    }

    private String getSenderClientId() {
        return this.getClientId(SENDER_PREFIX);
    }

    private String getReceiverClientId() {
        return this.getClientId(RECEIVER_PREFIX);
    }

    private String getReplyReceiverClientId() {
        return this.getClientId(REPLY_RECEIVER_PREFIX);
    }
}

