/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.mqtt.paho.client;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.joynr.messaging.mqtt.JoynrMqttClient;
import io.joynr.messaging.mqtt.MqttClientFactory;
import io.joynr.messaging.mqtt.paho.client.MqttPahoClient;
import joynr.system.RoutingTypes.MqttAddress;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MqttPahoClientFactory
implements MqttClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(MqttPahoClientFactory.class);
    private MqttAddress ownAddress;
    private JoynrMqttClient mqttClient = null;
    private int reconnectSleepMs;

    @Inject
    public MqttPahoClientFactory(@Named(value="property_mqtt_address") MqttAddress ownAddress, @Named(value="joynr.messaging.mqtt.reconnect.sleepms") int reconnectSleepMs) {
        this.ownAddress = ownAddress;
        this.reconnectSleepMs = reconnectSleepMs;
    }

    @Override
    public synchronized JoynrMqttClient create() {
        if (this.mqttClient == null) {
            this.mqttClient = this.createInternal();
        }
        return this.mqttClient;
    }

    private JoynrMqttClient createInternal() {
        MqttPahoClient pahoClient = null;
        try {
            logger.debug("Create Mqtt Client. Address: {}", (Object)this.ownAddress);
            MqttClient mqttClient = new MqttClient(this.ownAddress.getBrokerUri(), this.ownAddress.getTopic(), (MqttClientPersistence)new MemoryPersistence());
            pahoClient = new MqttPahoClient(mqttClient, new MqttAddress(this.ownAddress), this.reconnectSleepMs);
        }
        catch (MqttException e) {
            logger.error("Create MqttClient failed", (Throwable)e);
        }
        return pahoClient;
    }
}

