/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.mqtt;

import io.joynr.messaging.FailureAction;
import io.joynr.messaging.IMessaging;
import io.joynr.messaging.JoynrMessageSerializer;
import io.joynr.messaging.mqtt.JoynrMqttClient;
import joynr.JoynrMessage;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.MqttAddress;
import joynr.system.RoutingTypes.RoutingTypesUtil;

public class MqttMessagingStub
implements IMessaging {
    private static final String PRIORITY_LOW = "/low/";
    private static final String RAW = "/low/raw";
    private MqttAddress address;
    private JoynrMqttClient mqttClient;
    private JoynrMessageSerializer messageSerializer;
    private MqttAddress replyToMqttAddress;

    public MqttMessagingStub(MqttAddress address, MqttAddress replyToMqttAddress, JoynrMqttClient mqttClient, JoynrMessageSerializer messageSerializer) {
        this.address = address;
        this.replyToMqttAddress = replyToMqttAddress;
        this.mqttClient = mqttClient;
        this.messageSerializer = messageSerializer;
    }

    public void transmit(JoynrMessage message, FailureAction failureAction) {
        this.setReplyTo(message);
        String topic = this.address.getTopic() + PRIORITY_LOW + message.getTo();
        String serializedMessage = this.messageSerializer.serialize(message);
        try {
            this.mqttClient.publishMessage(topic, serializedMessage);
        }
        catch (Throwable error) {
            failureAction.execute(error);
        }
    }

    public void transmit(String serializedMessage, FailureAction failureAction) {
        String topic = this.address.getTopic() + RAW;
        try {
            this.mqttClient.publishMessage(topic, serializedMessage);
        }
        catch (Throwable error) {
            failureAction.execute(error);
        }
    }

    private void setReplyTo(JoynrMessage message) {
        String type = message.getType();
        if (type != null && message.getReplyTo() == null && (type.equals("request") || type.equals("subscriptionRequest") || type.equals("broadcastSubscriptionRequest"))) {
            message.setReplyTo(RoutingTypesUtil.toAddressString((Address)this.replyToMqttAddress));
        }
    }
}

