/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.mqtt;

import io.joynr.messaging.FailureAction;
import io.joynr.messaging.IMessaging;
import io.joynr.messaging.JoynrMessageSerializer;
import io.joynr.messaging.MessagingQosEffort;
import io.joynr.messaging.mqtt.JoynrMqttClient;
import io.joynr.messaging.mqtt.MqttMessageReplyToAddressCalculator;
import joynr.JoynrMessage;
import joynr.system.RoutingTypes.MqttAddress;

public class MqttMessagingStub
implements IMessaging {
    public static final int DEFAULT_QOS_LEVEL = 1;
    public static final int BEST_EFFORT_QOS_LEVEL = 0;
    private static final String PRIORITY_LOW = "/low/";
    private static final String RAW = "/low/raw";
    private MqttAddress address;
    private JoynrMqttClient mqttClient;
    private JoynrMessageSerializer messageSerializer;
    private MqttMessageReplyToAddressCalculator mqttMessageReplyToAddressCalculator;

    public MqttMessagingStub(MqttAddress address, JoynrMqttClient mqttClient, JoynrMessageSerializer messageSerializer, MqttMessageReplyToAddressCalculator mqttMessageReplyToAddressCalculator) {
        this.address = address;
        this.mqttClient = mqttClient;
        this.messageSerializer = messageSerializer;
        this.mqttMessageReplyToAddressCalculator = mqttMessageReplyToAddressCalculator;
    }

    public void transmit(JoynrMessage message, FailureAction failureAction) {
        this.mqttMessageReplyToAddressCalculator.setReplyTo(message);
        String topic = this.address.getTopic();
        if (!"multicast".equals(message.getType())) {
            topic = topic + PRIORITY_LOW + message.getTo();
        }
        String serializedMessage = this.messageSerializer.serialize(message);
        int qosLevel = 1;
        String effortHeaderValue = message.getHeaderValue("effort");
        if (effortHeaderValue != null && String.valueOf(MessagingQosEffort.BEST_EFFORT).equals(effortHeaderValue)) {
            qosLevel = 0;
        }
        try {
            this.mqttClient.publishMessage(topic, serializedMessage, qosLevel);
        }
        catch (Exception error) {
            failureAction.execute((Throwable)error);
        }
    }

    public void transmit(String serializedMessage, FailureAction failureAction) {
        String topic = this.address.getTopic() + RAW;
        try {
            this.mqttClient.publishMessage(topic, serializedMessage);
        }
        catch (Exception error) {
            failureAction.execute((Throwable)error);
        }
    }
}

