/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.mqtt.paho.client;

import io.joynr.exceptions.JoynrDelayMessageException;
import io.joynr.exceptions.JoynrIllegalStateException;
import io.joynr.exceptions.JoynrMessageNotSentException;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.messaging.FailureAction;
import io.joynr.messaging.IMessaging;
import io.joynr.messaging.mqtt.JoynrMqttClient;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttPahoClient
implements JoynrMqttClient,
MqttCallback {
    public static final String MQTT_PRIO = "low";
    private static final Logger logger = LoggerFactory.getLogger(MqttPahoClient.class);
    private MqttClient mqttClient;
    private IMessaging messagingSkeleton;
    private int reconnectSleepMs;
    private Set<String> subscribedTopics = new HashSet<String>();

    public MqttPahoClient(MqttClient mqttClient, int reconnectSleepMs) throws MqttException {
        this.mqttClient = mqttClient;
        this.reconnectSleepMs = reconnectSleepMs;
    }

    @Override
    public void start() {
        block9: while (!this.mqttClient.isConnected()) {
            try {
                this.mqttClient.connect(this.getConnectOptions());
                this.mqttClient.setCallback((MqttCallback)this);
                logger.debug("MQTT Connected client");
                for (String topic : this.subscribedTopics) {
                    this.subscribe(topic);
                }
            }
            catch (MqttException mqttError) {
                logger.error("MQTT Connect failed.", (Throwable)mqttError);
                switch (mqttError.getReasonCode()) {
                    case 0: 
                    case 3: 
                    case 6: 
                    case 128: 
                    case 32000: 
                    case 32001: 
                    case 32002: 
                    case 32102: 
                    case 32103: 
                    case 32104: 
                    case 32109: 
                    case 32110: 
                    case 32202: {
                        try {
                            Thread.sleep(this.reconnectSleepMs);
                            continue block9;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                    case 32100: {
                        continue block9;
                    }
                }
            }
            catch (Exception e) {
                throw new JoynrIllegalStateException("Unable to start MqttPahoClient: " + e.getMessage(), e);
            }
        }
    }

    private MqttConnectOptions getConnectOptions() {
        MqttConnectOptions options = new MqttConnectOptions();
        options.setAutomaticReconnect(false);
        options.setConnectionTimeout(120);
        options.setKeepAliveInterval(60);
        options.setCleanSession(false);
        return options;
    }

    @Override
    public void subscribe(String topic) {
        boolean subscribed = false;
        block9: while (!subscribed) {
            logger.debug("MQTT subscribed to: {}", (Object)topic);
            try {
                this.mqttClient.subscribe(topic);
                subscribed = true;
                this.subscribedTopics.add(topic);
            }
            catch (MqttException mqttError) {
                logger.debug("MQTT subscribe to: " + topic + " failed: " + mqttError.getMessage(), (Throwable)mqttError);
                switch (mqttError.getReasonCode()) {
                    case 0: 
                    case 3: 
                    case 6: 
                    case 128: 
                    case 32000: 
                    case 32001: 
                    case 32002: 
                    case 32103: 
                    case 32110: 
                    case 32202: {
                        try {
                            Thread.sleep(this.reconnectSleepMs);
                            continue block9;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                    case 32102: 
                    case 32104: 
                    case 32109: {
                        throw new JoynrIllegalStateException("client is not connected");
                    }
                }
            }
            catch (Exception e) {
                throw new JoynrRuntimeException("Unable to start MqttPahoClient", (Throwable)e);
            }
        }
    }

    @Override
    public void unsubscribe(String topic) {
        try {
            this.mqttClient.unsubscribe(topic);
        }
        catch (MqttException e) {
            throw new JoynrRuntimeException("Unable to unsubscribe from " + topic, (Throwable)e);
        }
    }

    @Override
    public void shutdown() {
        logger.info("Attempting shutdown of MQTT connection.");
        try {
            this.mqttClient.disconnect();
            this.mqttClient.close();
        }
        catch (Exception e) {
            logger.error("MQTT Close failed", (Throwable)e);
        }
    }

    @Override
    public void publishMessage(String topic, String serializedMessage) {
        this.publishMessage(topic, serializedMessage, 1);
    }

    @Override
    public void publishMessage(String topic, String serializedMessage, int qosLevel) {
        if (this.messagingSkeleton == null) {
            throw new JoynrDelayMessageException("MQTT Publish failed: messagingSkeleton has not been set yet");
        }
        try {
            MqttMessage message = new MqttMessage();
            message.setPayload(serializedMessage.getBytes(Charset.forName("UTF-8")));
            message.setQos(qosLevel);
            message.setRetained(false);
            logger.debug("MQTT Publish to: {}", (Object)topic);
            this.mqttClient.publish(topic, message);
        }
        catch (MqttException e) {
            logger.debug("MQTT Publish failed: {}", (Object)e.getMessage(), (Object)e);
            switch (e.getReasonCode()) {
                case 0: {
                    Throwable cause = e.getCause();
                    if (cause != null) {
                        throw new JoynrDelayMessageException("MqttException: " + cause.getMessage());
                    }
                    throw new JoynrDelayMessageException("MqttException: " + e.getMessage());
                }
                case 3: 
                case 6: 
                case 32000: 
                case 32001: 
                case 32002: 
                case 32102: 
                case 32103: 
                case 32104: 
                case 32109: 
                case 32110: 
                case 32202: {
                    throw new JoynrDelayMessageException("MqttException: " + e.getMessage());
                }
            }
            throw new JoynrMessageNotSentException(e.getMessage());
        }
        catch (Exception e) {
            throw new JoynrMessageNotSentException(e.getMessage(), (Throwable)e);
        }
        logger.debug("Published message: " + serializedMessage);
    }

    public void connectionLost(Throwable error) {
        logger.error("MQTT connection lost: {}", (Object)error.getMessage());
        logger.trace("Connection lost because of error", error);
        if (error instanceof MqttException) {
            MqttException mqttError = (MqttException)error;
            int reason = mqttError.getReasonCode();
            switch (reason) {
                case 0: {
                    this.connectionLost(mqttError.getCause());
                    break;
                }
                case 3: 
                case 6: 
                case 32000: 
                case 32002: 
                case 32103: 
                case 32104: 
                case 32109: {
                    this.start();
                    break;
                }
                default: {
                    this.shutdown();
                }
            }
        }
    }

    public void deliveryComplete(IMqttDeliveryToken arg0) {
    }

    public void messageArrived(String topic, MqttMessage mqttMessage) throws Exception {
        String serializedMessage = new String(mqttMessage.getPayload(), Charset.forName("UTF-8"));
        logger.debug("Received message via MQTT from topic {}:\n{}", (Object)topic, (Object)serializedMessage);
        if (this.messagingSkeleton == null) {
            logger.error("MQTT message not processed: messagingSkeleton has not been set yet");
            return;
        }
        this.messagingSkeleton.transmit(serializedMessage, new FailureAction(){

            public void execute(Throwable error) {
                logger.error("MQTT message not processed");
            }
        });
    }

    @Override
    public void setMessageListener(IMessaging messaging) {
        this.messagingSkeleton = messaging;
    }
}

