/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.mqtt;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.exceptions.JoynrMessageNotSentException;
import io.joynr.exceptions.JoynrSendBufferFullException;
import io.joynr.messaging.FailureAction;
import io.joynr.messaging.IMessaging;
import io.joynr.messaging.IMessagingMulticastSubscriber;
import io.joynr.messaging.IMessagingSkeleton;
import io.joynr.messaging.JoynrMessageSerializer;
import io.joynr.messaging.mqtt.JoynrMqttClient;
import io.joynr.messaging.mqtt.MqttClientFactory;
import io.joynr.messaging.mqtt.MqttMessageSerializerFactory;
import io.joynr.messaging.routing.MessageRouter;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import joynr.JoynrMessage;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.MqttAddress;
import joynr.system.RoutingTypes.RoutingTypesUtil;

public class MqttMessagingSkeleton
implements IMessagingSkeleton,
IMessagingMulticastSubscriber {
    private MessageRouter messageRouter;
    private JoynrMqttClient mqttClient;
    private JoynrMessageSerializer messageSerializer;
    private MqttClientFactory mqttClientFactory;
    private MqttAddress ownAddress;
    private ConcurrentMap<String, AtomicInteger> multicastSubscriptionCount = Maps.newConcurrentMap();

    @Inject
    public MqttMessagingSkeleton(@Named(value="property_mqtt_address") MqttAddress ownAddress, MessageRouter messageRouter, MqttClientFactory mqttClientFactory, MqttMessageSerializerFactory messageSerializerFactory) {
        this.ownAddress = ownAddress;
        this.messageRouter = messageRouter;
        this.mqttClientFactory = mqttClientFactory;
        this.messageSerializer = messageSerializerFactory.create((Address)ownAddress);
    }

    public void init() {
        this.mqttClient = this.mqttClientFactory.create();
        this.mqttClient.setMessageListener((IMessaging)this);
        this.mqttClient.start();
        this.subscribe();
    }

    protected void subscribe() {
        this.mqttClient.subscribe(this.ownAddress.getTopic() + "/#");
    }

    public void shutdown() {
        this.mqttClient.shutdown();
    }

    public void registerMulticastSubscription(String multicastId) {
        this.multicastSubscriptionCount.putIfAbsent(multicastId, new AtomicInteger());
        int numberOfSubscriptions = ((AtomicInteger)this.multicastSubscriptionCount.get(multicastId)).incrementAndGet();
        if (numberOfSubscriptions == 1) {
            this.mqttClient.subscribe(this.translateWildcard(multicastId));
        }
    }

    public void unregisterMulticastSubscription(String multicastId) {
        int remainingCount;
        AtomicInteger subscribersCount = (AtomicInteger)this.multicastSubscriptionCount.get(multicastId);
        if (subscribersCount != null && (remainingCount = subscribersCount.decrementAndGet()) == 0) {
            this.mqttClient.unsubscribe(this.translateWildcard(multicastId));
        }
    }

    private String translateWildcard(String multicastId) {
        String topic = multicastId;
        if (topic.endsWith("/*")) {
            topic = topic.replaceFirst("/\\*$", "/#");
        }
        return topic;
    }

    public void transmit(JoynrMessage message, FailureAction failureAction) {
        try {
            String replyToMqttAddress;
            if ("multicast".equals(message.getType())) {
                message.setReceivedFromGlobal(true);
            }
            if ((replyToMqttAddress = message.getHeaderValue("replyChannelId")) != null && !replyToMqttAddress.isEmpty()) {
                this.messageRouter.addNextHop(message.getFrom(), RoutingTypesUtil.fromAddressString((String)replyToMqttAddress));
            }
            this.messageRouter.route(message);
        }
        catch (JoynrMessageNotSentException | JoynrSendBufferFullException e) {
            failureAction.execute(e);
        }
    }

    public void transmit(String serializedMessage, FailureAction failureAction) {
        JoynrMessage message = this.messageSerializer.deserialize(serializedMessage);
        this.transmit(message, failureAction);
    }

    protected JoynrMqttClient getClient() {
        return this.mqttClient;
    }

    protected MqttAddress getOwnAddress() {
        return this.ownAddress;
    }
}

