/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.mqtt;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import io.joynr.messaging.AbstractMiddlewareMessagingStubFactory;
import io.joynr.messaging.IMessaging;
import io.joynr.messaging.IMessagingSkeleton;
import io.joynr.messaging.mqtt.DefaultMqttMessageReplyToAddressCalculator;
import io.joynr.messaging.mqtt.MqttGlobalAddressFactory;
import io.joynr.messaging.mqtt.MqttMessageReplyToAddressCalculator;
import io.joynr.messaging.mqtt.MqttMessageSerializerFactory;
import io.joynr.messaging.mqtt.MqttMessagingSkeleton;
import io.joynr.messaging.mqtt.MqttMessagingStubFactory;
import io.joynr.messaging.mqtt.MqttMulticastAddressCalculator;
import io.joynr.messaging.routing.GlobalAddressFactory;
import io.joynr.messaging.routing.MulticastAddressCalculator;
import io.joynr.messaging.serialize.AbstractMiddlewareMessageSerializerFactory;
import java.lang.annotation.Annotation;
import javax.inject.Named;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.MqttAddress;

public class MqttModule
extends AbstractModule {
    public static final String PROPERTY_KEY_MQTT_RECONNECT_SLEEP_MS = "joynr.messaging.mqtt.reconnect.sleepms";
    public static final String PROPERTY_KEY_MQTT_BROKER_URI = "joynr.messaging.mqtt.brokeruri";
    public static final String PROPERTY_MQTT_ADDRESS = "property_mqtt_address";

    @Provides
    @Named(value="property_mqtt_address")
    public MqttAddress provideMqttOwnAddress(MqttGlobalAddressFactory globalAddressFactory) {
        return globalAddressFactory.create();
    }

    protected void configure() {
        MapBinder messagingStubFactory = MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<Class<? extends Address>>(){}, (TypeLiteral)new TypeLiteral<AbstractMiddlewareMessagingStubFactory<? extends IMessaging, ? extends Address>>(){}, (Annotation)Names.named((String)"MIDDLEWARE_MESSAGING_STUB_FACTORIES"));
        messagingStubFactory.addBinding(MqttAddress.class).to(MqttMessagingStubFactory.class);
        MapBinder messageSerializerFactory = MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<Class<? extends Address>>(){}, (TypeLiteral)new TypeLiteral<AbstractMiddlewareMessageSerializerFactory<? extends Address>>(){}, (Annotation)Names.named((String)"middleware_message_serializer_factories"));
        messageSerializerFactory.addBinding(MqttAddress.class).to(MqttMessageSerializerFactory.class);
        MapBinder messagingSkeletonFactory = MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<Class<? extends Address>>(){}, (TypeLiteral)new TypeLiteral<IMessagingSkeleton>(){}, (Annotation)Names.named((String)"MIDDLEWARE_MESSAGING_SKELETONS"));
        messagingSkeletonFactory.addBinding(MqttAddress.class).to(MqttMessagingSkeleton.class);
        Multibinder globalAddresses = Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<GlobalAddressFactory<? extends Address>>(){});
        globalAddresses.addBinding().to(MqttGlobalAddressFactory.class);
        Multibinder multicastAddressCalculators = Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<MulticastAddressCalculator>(){});
        multicastAddressCalculators.addBinding().to(MqttMulticastAddressCalculator.class);
        this.bind(MqttMessageReplyToAddressCalculator.class).to(DefaultMqttMessageReplyToAddressCalculator.class);
    }
}

