/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.mqtt;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.messaging.routing.MulticastAddressCalculator;
import joynr.JoynrMessage;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.MqttAddress;

public class MqttMulticastAddressCalculator
implements MulticastAddressCalculator {
    private MqttAddress globalAddress;

    @Inject
    public MqttMulticastAddressCalculator(@Named(value="property_mqtt_address") MqttAddress globalAddress) {
        this.globalAddress = globalAddress;
    }

    public Address calculate(JoynrMessage message) {
        MqttAddress result = null;
        if (this.globalAddress != null) {
            result = new MqttAddress(this.globalAddress.getBrokerUri(), message.getTo());
        }
        return result;
    }

    public boolean supports(String transport) {
        return "mqtt".equalsIgnoreCase(transport);
    }
}

