/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.mqtt;

import com.google.inject.Inject;
import io.joynr.messaging.AbstractMiddlewareMessagingStubFactory;
import io.joynr.messaging.JoynrMessageSerializer;
import io.joynr.messaging.mqtt.JoynrMqttClient;
import io.joynr.messaging.mqtt.MqttClientFactory;
import io.joynr.messaging.mqtt.MqttMessageReplyToAddressCalculator;
import io.joynr.messaging.mqtt.MqttMessageSerializerFactory;
import io.joynr.messaging.mqtt.MqttMessagingStub;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.MqttAddress;

public class MqttMessagingStubFactory
extends AbstractMiddlewareMessagingStubFactory<MqttMessagingStub, MqttAddress> {
    private MqttMessageSerializerFactory mqttMessageSerializerFactory;
    private JoynrMqttClient mqttClient;
    private MqttMessageReplyToAddressCalculator mqttMessageReplyToAddressCalculator;

    @Inject
    public MqttMessagingStubFactory(MqttMessageSerializerFactory mqttMessageSerializerFactory, MqttMessageReplyToAddressCalculator mqttMessageReplyToAddressCalculator, MqttClientFactory mqttClientFactory) {
        this.mqttMessageSerializerFactory = mqttMessageSerializerFactory;
        this.mqttClient = mqttClientFactory.create();
        this.mqttMessageReplyToAddressCalculator = mqttMessageReplyToAddressCalculator;
    }

    protected MqttMessagingStub createInternal(MqttAddress address) {
        JoynrMessageSerializer messageSerializer = this.mqttMessageSerializerFactory.create((Address)address);
        return new MqttMessagingStub(address, this.mqttClient, messageSerializer, this.mqttMessageReplyToAddressCalculator);
    }

    public void shutdown() {
    }
}

