/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.mqtt;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import io.joynr.messaging.IMessagingSkeleton;
import io.joynr.messaging.mqtt.MqttClientFactory;
import io.joynr.messaging.mqtt.MqttMessageSerializerFactory;
import io.joynr.messaging.mqtt.MqttMessagingSkeleton;
import io.joynr.messaging.mqtt.MqttTopicPrefixProvider;
import io.joynr.messaging.mqtt.SharedSubscriptionsMqttMessagingSkeleton;
import io.joynr.messaging.routing.MessageRouter;
import joynr.system.RoutingTypes.MqttAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttMessagingSkeletonProvider
implements Provider<IMessagingSkeleton> {
    private static final Logger logger = LoggerFactory.getLogger(MqttMessagingSkeletonProvider.class);
    protected MqttClientFactory mqttClientFactory;
    private boolean sharedSubscriptionsEnabled;
    private MqttAddress ownAddress;
    private MqttAddress replyToAddress;
    private MessageRouter messageRouter;
    private MqttMessageSerializerFactory messageSerializerFactory;
    private String channelId;
    private MqttTopicPrefixProvider mqttTopicPrefixProvider;

    @Inject
    public MqttMessagingSkeletonProvider(@Named(value="joynr.messaging.mqtt.enable.sharedsubscriptions") String enableSharedSubscriptions, @Named(value="property_mqtt_global_address") MqttAddress ownAddress, @Named(value="property_mqtt_reply_to_address") MqttAddress replyToAddress, MessageRouter messageRouter, MqttClientFactory mqttClientFactory, MqttMessageSerializerFactory messageSerializerFactory, @Named(value="joynr.messaging.channelid") String channelId, MqttTopicPrefixProvider mqttTopicPrefixProvider) {
        this.sharedSubscriptionsEnabled = Boolean.valueOf(enableSharedSubscriptions);
        this.ownAddress = ownAddress;
        this.replyToAddress = replyToAddress;
        this.messageRouter = messageRouter;
        this.mqttClientFactory = mqttClientFactory;
        this.messageSerializerFactory = messageSerializerFactory;
        this.channelId = channelId;
        this.mqttTopicPrefixProvider = mqttTopicPrefixProvider;
        logger.debug("Created with sharedSubscriptionsEnabled: {} ownAddress: {} channelId: {}", new Object[]{this.sharedSubscriptionsEnabled, this.ownAddress, this.channelId});
    }

    public IMessagingSkeleton get() {
        if (this.sharedSubscriptionsEnabled) {
            return new SharedSubscriptionsMqttMessagingSkeleton(this.ownAddress, this.replyToAddress, this.messageRouter, this.mqttClientFactory, this.messageSerializerFactory, this.channelId, this.mqttTopicPrefixProvider);
        }
        return new MqttMessagingSkeleton(this.ownAddress, this.messageRouter, this.mqttClientFactory, this.messageSerializerFactory, this.mqttTopicPrefixProvider);
    }
}

