/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.mqtt.paho.client;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.joynr.messaging.mqtt.JoynrMqttClient;
import io.joynr.messaging.mqtt.MqttClientFactory;
import io.joynr.messaging.mqtt.MqttClientIdProvider;
import io.joynr.messaging.mqtt.paho.client.MqttPahoClient;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import joynr.system.RoutingTypes.MqttAddress;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MqttPahoClientFactory
implements MqttClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(MqttPahoClientFactory.class);
    private MqttAddress ownAddress;
    private JoynrMqttClient mqttClient = null;
    private int reconnectSleepMs;
    private int keepAliveTimerSec;
    private int connectionTimeoutSec;
    private int timeToWaitMs;
    private ScheduledExecutorService scheduledExecutorService;
    private MqttClientIdProvider clientIdProvider;

    @Inject
    public MqttPahoClientFactory(@Named(value="property_mqtt_global_address") MqttAddress ownAddress, @Named(value="joynr.messaging.mqtt.reconnect.sleepms") int reconnectSleepMs, @Named(value="joynr.messaging.mqtt.keepalivetimersec") int keepAliveTimerSec, @Named(value="joynr.messaging.mqtt.connectiontimeoutsec") int connectionTimeoutSec, @Named(value="joynr.messaging.mqtt.timetowaitms") int timeToWaitMs, @Named(value="io.joynr.messaging.scheduledthreadpool") ScheduledExecutorService scheduledExecutorService, MqttClientIdProvider mqttClientIdProvider) {
        this.ownAddress = ownAddress;
        this.reconnectSleepMs = reconnectSleepMs;
        this.scheduledExecutorService = scheduledExecutorService;
        this.clientIdProvider = mqttClientIdProvider;
        this.keepAliveTimerSec = keepAliveTimerSec;
        this.connectionTimeoutSec = connectionTimeoutSec;
        this.timeToWaitMs = timeToWaitMs;
    }

    @Override
    public synchronized JoynrMqttClient create() {
        if (this.mqttClient == null) {
            this.mqttClient = this.createInternal();
        }
        return this.mqttClient;
    }

    private JoynrMqttClient createInternal() {
        MqttPahoClient pahoClient = null;
        try {
            logger.debug("Create Mqtt Client. Address: {}", (Object)this.ownAddress);
            String clientId = this.clientIdProvider.getClientId();
            MqttClient mqttClient = new MqttClient(this.ownAddress.getBrokerUri(), clientId, (MqttClientPersistence)new MemoryPersistence(), (ExecutorService)this.scheduledExecutorService);
            pahoClient = new MqttPahoClient(mqttClient, this.reconnectSleepMs, this.keepAliveTimerSec, this.connectionTimeoutSec, this.timeToWaitMs);
        }
        catch (MqttException e) {
            logger.error("Create MqttClient failed", (Throwable)e);
        }
        return pahoClient;
    }
}

