/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.mqtt;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.messaging.mqtt.MqttTopicPrefixProvider;
import io.joynr.messaging.routing.MulticastAddressCalculator;
import joynr.JoynrMessage;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.MqttAddress;

public class MqttMulticastAddressCalculator
implements MulticastAddressCalculator {
    private MqttAddress globalAddress;
    private MqttTopicPrefixProvider mqttTopicPrefixProvider;

    @Inject
    public MqttMulticastAddressCalculator(@Named(value="property_mqtt_global_address") MqttAddress globalAddress, MqttTopicPrefixProvider mqttTopicPrefixProvider) {
        this.globalAddress = globalAddress;
        this.mqttTopicPrefixProvider = mqttTopicPrefixProvider;
    }

    public Address calculate(JoynrMessage message) {
        MqttAddress result = null;
        if (this.globalAddress != null) {
            String topic = this.mqttTopicPrefixProvider.getMulticastTopicPrefix() + message.getTo();
            result = new MqttAddress(this.globalAddress.getBrokerUri(), topic);
        }
        return result;
    }

    public boolean supports(String transport) {
        return "mqtt".equalsIgnoreCase(transport);
    }
}

