/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.mqtt;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.joynr.messaging.mqtt.MqttClientIdProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultMqttClientIdProvider
implements MqttClientIdProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMqttClientIdProvider.class);
    private static final String DEFAULT_CLIENT_ID_PREFIX = "";
    private String clientId;

    @Inject
    public DefaultMqttClientIdProvider(@Named(value="joynr.messaging.receiverid") String receiverId, ClientIdPrefixHolder clientIdPrefixHolder) {
        String clientIdPrefix = clientIdPrefixHolder.clientIdPrefix;
        if (receiverId.length() != 16) {
            LOG.warn("ReceiverId " + receiverId + " is not a UUID of expected length 16");
        }
        this.clientId = clientIdPrefix + "joynr:" + receiverId.substring(0, Math.min(17, receiverId.length() + 1));
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    static class ClientIdPrefixHolder {
        @Inject(optional=true)
        @Named(value="joynr.messaging.mqtt.clientidprefix")
        String clientIdPrefix = "";

        ClientIdPrefixHolder() {
        }
    }
}

