/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.mqtt;

import io.joynr.messaging.FailureAction;
import io.joynr.messaging.IMessagingStub;
import io.joynr.messaging.MessagingQosEffort;
import io.joynr.messaging.mqtt.JoynrMqttClient;
import joynr.ImmutableMessage;
import joynr.system.RoutingTypes.MqttAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttMessagingStub
implements IMessagingStub {
    private static final Logger LOG = LoggerFactory.getLogger(MqttMessagingStub.class);
    public static final int DEFAULT_QOS_LEVEL = 1;
    public static final int BEST_EFFORT_QOS_LEVEL = 0;
    private static final String PRIORITY_LOW = "/low/";
    private MqttAddress address;
    private JoynrMqttClient mqttClient;

    public MqttMessagingStub(MqttAddress address, JoynrMqttClient mqttClient) {
        this.address = address;
        this.mqttClient = mqttClient;
    }

    public void transmit(ImmutableMessage message, FailureAction failureAction) {
        LOG.debug(">>> OUTGOING >>> {}", (Object)message.toLogMessage());
        String topic = this.address.getTopic();
        if (!"m".equals(message.getType())) {
            topic = topic + PRIORITY_LOW + message.getRecipient();
        }
        int qosLevel = 1;
        String effortHeaderValue = message.getEffort();
        if (effortHeaderValue != null && String.valueOf(MessagingQosEffort.BEST_EFFORT).equals(effortHeaderValue)) {
            qosLevel = 0;
        }
        try {
            this.mqttClient.publishMessage(topic, message.getSerializedMessage(), qosLevel);
        }
        catch (Exception error) {
            failureAction.execute((Throwable)error);
        }
    }
}

