/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.mqtt;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import io.joynr.messaging.AbstractMiddlewareMessagingStubFactory;
import io.joynr.messaging.IMessagingSkeleton;
import io.joynr.messaging.IMessagingStub;
import io.joynr.messaging.mqtt.DefaultMqttClientIdProvider;
import io.joynr.messaging.mqtt.DefaultMqttTopicPrefixProvider;
import io.joynr.messaging.mqtt.MqttClientIdProvider;
import io.joynr.messaging.mqtt.MqttGlobalAddressFactory;
import io.joynr.messaging.mqtt.MqttMessagingSkeletonProvider;
import io.joynr.messaging.mqtt.MqttMessagingStubFactory;
import io.joynr.messaging.mqtt.MqttMulticastAddressCalculator;
import io.joynr.messaging.mqtt.MqttReplyToAddressFactory;
import io.joynr.messaging.mqtt.MqttTopicPrefixProvider;
import io.joynr.messaging.routing.GlobalAddressFactory;
import io.joynr.messaging.routing.MulticastAddressCalculator;
import java.lang.annotation.Annotation;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.MqttAddress;

public class MqttModule
extends AbstractModule {
    public static final String PROPERTY_KEY_MQTT_RECONNECT_SLEEP_MS = "joynr.messaging.mqtt.reconnect.sleepms";
    public static final String PROPERTY_KEY_MQTT_BROKER_URI = "joynr.messaging.mqtt.brokeruri";
    public static final String PROPERTY_KEY_MQTT_CLIENT_ID_PREFIX = "joynr.messaging.mqtt.clientidprefix";
    public static final String PROPERTY_MQTT_GLOBAL_ADDRESS = "property_mqtt_global_address";
    public static final String PROPERTY_MQTT_REPLY_TO_ADDRESS = "property_mqtt_reply_to_address";
    public static final String PROPERTY_KEY_MQTT_KEEP_ALIVE_TIMER_SEC = "joynr.messaging.mqtt.keepalivetimersec";
    public static final String PROPERTY_KEY_MQTT_CONNECTION_TIMEOUT_SEC = "joynr.messaging.mqtt.connectiontimeoutsec";
    public static final String PROPERTY_KEY_MQTT_TIME_TO_WAIT_MS = "joynr.messaging.mqtt.timetowaitms";
    public static final String PROPERTY_KEY_MQTT_ENABLE_SHARED_SUBSCRIPTIONS = "joynr.messaging.mqtt.enable.sharedsubscriptions";
    public static final String PROPERTY_KEY_MQTT_MAX_MSGS_INFLIGHT = "joynr.messaging.mqtt.maxmsgsinflight";

    @Provides
    @Named(value="property_mqtt_global_address")
    public MqttAddress provideMqttOwnAddress(MqttGlobalAddressFactory globalAddressFactory) {
        return globalAddressFactory.create();
    }

    @Provides
    @Named(value="property_mqtt_reply_to_address")
    public MqttAddress provideMqttOwnAddress(MqttReplyToAddressFactory replyToAddressFactory) {
        return replyToAddressFactory.create();
    }

    protected void configure() {
        MapBinder messagingStubFactory = MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<Class<? extends Address>>(){}, (TypeLiteral)new TypeLiteral<AbstractMiddlewareMessagingStubFactory<? extends IMessagingStub, ? extends Address>>(){}, (Annotation)Names.named((String)"MIDDLEWARE_MESSAGING_STUB_FACTORIES"));
        messagingStubFactory.addBinding(MqttAddress.class).to(MqttMessagingStubFactory.class);
        MapBinder messagingSkeletonFactory = MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<Class<? extends Address>>(){}, (TypeLiteral)new TypeLiteral<IMessagingSkeleton>(){}, (Annotation)Names.named((String)"MIDDLEWARE_MESSAGING_SKELETONS"));
        messagingSkeletonFactory.addBinding(MqttAddress.class).toProvider(MqttMessagingSkeletonProvider.class);
        Multibinder globalAddresses = Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<GlobalAddressFactory<? extends Address>>(){}, (Annotation)Names.named((String)"global_address_provider"));
        globalAddresses.addBinding().to(MqttGlobalAddressFactory.class);
        Multibinder replyToAddresses = Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<GlobalAddressFactory<? extends Address>>(){}, (Annotation)Names.named((String)"reply_to_address_provider"));
        replyToAddresses.addBinding().to(MqttReplyToAddressFactory.class);
        Multibinder multicastAddressCalculators = Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<MulticastAddressCalculator>(){});
        multicastAddressCalculators.addBinding().to(MqttMulticastAddressCalculator.class);
        this.bind(MqttClientIdProvider.class).to(DefaultMqttClientIdProvider.class);
        this.bind(MqttTopicPrefixProvider.class).to(DefaultMqttTopicPrefixProvider.class);
    }
}

