/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.mqtt.paho.client;

import com.google.common.base.Charsets;
import io.joynr.exceptions.JoynrDelayMessageException;
import io.joynr.exceptions.JoynrIllegalStateException;
import io.joynr.exceptions.JoynrMessageNotSentException;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.messaging.FailureAction;
import io.joynr.messaging.IMessagingSkeleton;
import io.joynr.messaging.mqtt.JoynrMqttClient;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttPahoClient
implements JoynrMqttClient,
MqttCallback {
    public static final String MQTT_PRIO = "low";
    private static final Logger logger = LoggerFactory.getLogger(MqttPahoClient.class);
    private MqttClient mqttClient;
    private IMessagingSkeleton messagingSkeleton;
    private int reconnectSleepMs;
    private int keepAliveTimerSec;
    private int connectionTimeoutSec;
    private int timeToWaitMs;
    private int maxMsgsInflight;
    private boolean disconnecting = false;
    private Set<String> subscribedTopics = new HashSet<String>();
    private boolean shutdown = false;

    public MqttPahoClient(MqttClient mqttClient, int reconnectSleepMS, int keepAliveTimerSec, int connectionTimeoutSec, int timeToWaitMs, int maxMsgsInflight) throws MqttException {
        this.mqttClient = mqttClient;
        this.reconnectSleepMs = reconnectSleepMS;
        this.keepAliveTimerSec = keepAliveTimerSec;
        this.connectionTimeoutSec = connectionTimeoutSec;
        this.timeToWaitMs = timeToWaitMs;
        this.maxMsgsInflight = maxMsgsInflight;
    }

    @Override
    public synchronized void start() {
        block9: while (!this.shutdown && !this.mqttClient.isConnected()) {
            try {
                this.mqttClient.setCallback((MqttCallback)this);
                this.mqttClient.setTimeToWait((long)this.timeToWaitMs);
                this.mqttClient.connect(this.getConnectOptions());
                logger.debug("MQTT Connected client");
                for (String topic : this.subscribedTopics) {
                    this.subscribe(topic);
                }
            }
            catch (MqttException mqttError) {
                logger.error("MQTT Connect failed. Error code {}", (Object)mqttError.getReasonCode(), (Object)mqttError);
                switch (mqttError.getReasonCode()) {
                    case 0: 
                    case 3: 
                    case 6: 
                    case 128: 
                    case 32000: 
                    case 32001: 
                    case 32002: 
                    case 32102: 
                    case 32103: 
                    case 32104: 
                    case 32109: 
                    case 32110: 
                    case 32202: {
                        if (this.shutdown) {
                            return;
                        }
                        try {
                            Thread.sleep(this.reconnectSleepMs);
                            continue block9;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                    case 32100: {
                        continue block9;
                    }
                }
            }
            catch (Exception e) {
                throw new JoynrIllegalStateException("Unable to start MqttPahoClient: " + e.getMessage(), e);
            }
        }
    }

    private MqttConnectOptions getConnectOptions() {
        MqttConnectOptions options = new MqttConnectOptions();
        options.setAutomaticReconnect(false);
        options.setConnectionTimeout(this.connectionTimeoutSec);
        options.setKeepAliveInterval(this.keepAliveTimerSec);
        options.setMaxInflight(this.maxMsgsInflight);
        options.setCleanSession(false);
        return options;
    }

    @Override
    public void subscribe(String topic) {
        boolean subscribed = false;
        block9: while (!subscribed) {
            logger.debug("MQTT subscribed to: {}", (Object)topic);
            try {
                this.mqttClient.subscribe(topic);
                subscribed = true;
                this.subscribedTopics.add(topic);
            }
            catch (MqttException mqttError) {
                logger.debug("MQTT subscribe to {} failed: {}. Error code {}", new Object[]{topic, mqttError.getMessage(), mqttError.getReasonCode(), mqttError});
                switch (mqttError.getReasonCode()) {
                    case 0: 
                    case 3: 
                    case 6: 
                    case 128: 
                    case 32000: 
                    case 32001: 
                    case 32002: 
                    case 32103: 
                    case 32110: 
                    case 32202: {
                        try {
                            Thread.sleep(this.reconnectSleepMs);
                            continue block9;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                    case 32102: 
                    case 32104: 
                    case 32109: {
                        throw new JoynrIllegalStateException("client is not connected");
                    }
                }
            }
            catch (Exception e) {
                throw new JoynrRuntimeException("Unable to start MqttPahoClient", (Throwable)e);
            }
        }
    }

    @Override
    public void unsubscribe(String topic) {
        try {
            this.mqttClient.unsubscribe(topic);
        }
        catch (MqttException e) {
            throw new JoynrRuntimeException("Unable to unsubscribe from " + topic, (Throwable)e);
        }
    }

    @Override
    public synchronized void shutdown() {
        this.shutdown = true;
        logger.info("Attempting shutdown of MQTT connection.");
        try {
            this.mqttClient.disconnectForcibly(10000L, 10000L);
            this.mqttClient.close();
        }
        catch (Exception e) {
            logger.error("MQTT Close failed", (Throwable)e);
        }
    }

    @Override
    public void publishMessage(String topic, byte[] serializedMessage) {
        this.publishMessage(topic, serializedMessage, 1);
    }

    @Override
    public void publishMessage(String topic, byte[] serializedMessage, int qosLevel) {
        if (this.messagingSkeleton == null) {
            throw new JoynrDelayMessageException("MQTT Publish failed: messagingSkeleton has not been set yet");
        }
        try {
            MqttMessage message = new MqttMessage();
            message.setPayload(serializedMessage);
            message.setQos(qosLevel);
            message.setRetained(false);
            logger.debug("MQTT Publish to: {}", (Object)topic);
            this.mqttClient.publish(topic, message);
        }
        catch (MqttException e) {
            logger.debug("MQTT Publish failed: {}. Error code {}", new Object[]{e.getMessage(), e.getReasonCode(), e});
            switch (e.getReasonCode()) {
                case 0: {
                    Throwable cause = e.getCause();
                    if (cause != null) {
                        throw new JoynrDelayMessageException("MqttException: " + cause.getMessage());
                    }
                    throw new JoynrDelayMessageException("MqttException: " + e.getMessage());
                }
                case 3: 
                case 6: 
                case 32000: 
                case 32001: 
                case 32002: 
                case 32102: 
                case 32103: 
                case 32104: 
                case 32109: 
                case 32110: 
                case 32202: {
                    throw new JoynrDelayMessageException("MqttException: " + e.getMessage());
                }
            }
            throw new JoynrMessageNotSentException(e.getMessage());
        }
        catch (Exception e) {
            throw new JoynrMessageNotSentException(e.getMessage(), (Throwable)e);
        }
        logger.debug("Published message: " + new String(serializedMessage, Charsets.UTF_8));
    }

    public void connectionLost(Throwable error) {
        if (error instanceof MqttException) {
            MqttException mqttError = (MqttException)error;
            int reason = mqttError.getReasonCode();
            switch (reason) {
                case 3: 
                case 6: 
                case 32000: 
                case 32002: 
                case 32104: 
                case 32108: 
                case 32109: {
                    logger.debug("MQTT connection lost, trying to reconnect. Error code {}", (Object)reason);
                    this.attemptDisconnectAndRestart();
                    break;
                }
                case 0: {
                    logger.error("MQTT connection lost due to client exception");
                    Throwable cause = mqttError.getCause();
                    if (cause != null) {
                        logger.error(cause.getMessage());
                    }
                    this.attemptDisconnectAndRestart();
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 32105: 
                case 32106: {
                    logger.error("MQTT Connection is incorrectly configured. Connection not possible: {}. Error code {}", (Object)mqttError.getMessage(), (Object)reason);
                    this.shutdown();
                    break;
                }
                case 32102: 
                case 32111: {
                    logger.trace("MQTT connection lost due to client shutting down. Error code {}", (Object)reason);
                    break;
                }
                default: {
                    logger.error("received error reason that should not have been thrown for connection loss: {}. Error code {}", (Object)mqttError.getMessage(), (Object)reason);
                    this.shutdown();
                    break;
                }
            }
        } else {
            logger.error("MQTT connection lost due to unknown error " + error);
            this.shutdown();
        }
    }

    private void attemptDisconnectAndRestart() {
        if (!this.disconnecting) {
            this.disconnecting = true;
            try {
                this.mqttClient.disconnect();
            }
            catch (Exception e) {
                logger.trace("Problem while attempting disconnect.", (Throwable)e);
                try {
                    this.mqttClient.disconnectForcibly();
                }
                catch (Exception e2) {
                    logger.trace("Problem while attempting to disconnect forcibly.", (Throwable)e2);
                }
            }
            finally {
                this.disconnecting = false;
                this.start();
            }
        }
    }

    public void deliveryComplete(IMqttDeliveryToken arg0) {
    }

    public void messageArrived(String topic, MqttMessage mqttMessage) throws Exception {
        logger.debug("Received message via MQTT from topic {}:\n{}", (Object)topic, (Object)new String(mqttMessage.getPayload(), Charsets.UTF_8));
        if (this.messagingSkeleton == null) {
            logger.error("MQTT message not processed: messagingSkeleton has not been set yet");
            return;
        }
        this.messagingSkeleton.transmit(mqttMessage.getPayload(), new FailureAction(){

            public void execute(Throwable error) {
                logger.error("MQTT message not processed");
            }
        });
    }

    @Override
    public void setMessageListener(IMessagingSkeleton messaging) {
        this.messagingSkeleton = messaging;
    }
}

