/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.mqtt;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.messaging.JoynrMessageProcessor;
import io.joynr.messaging.RawMessagingPreprocessor;
import io.joynr.messaging.mqtt.MqttClientFactory;
import io.joynr.messaging.mqtt.MqttMessagingSkeleton;
import io.joynr.messaging.mqtt.MqttTopicPrefixProvider;
import io.joynr.messaging.routing.MessageRouter;
import java.util.Set;
import joynr.system.RoutingTypes.MqttAddress;

public class SharedSubscriptionsMqttMessagingSkeleton
extends MqttMessagingSkeleton {
    private static final String NON_ALPHA_REGEX_PATTERN = "[^a-zA-Z]";
    private String channelId;
    private MqttAddress replyToAddress;

    @Inject
    public SharedSubscriptionsMqttMessagingSkeleton(@Named(value="property_mqtt_global_address") MqttAddress ownAddress, @Named(value="joynr.messaging.repeatedmqttmessageignoreperiodms") int repeatedMqttMessageIgnorePeriodMs, @Named(value="joynr.messaging.maxincomingmqttmessagesinqueue") int maxIncomingMqttMessagesInQueue, @Named(value="property_mqtt_reply_to_address") MqttAddress replyToAddress, MessageRouter messageRouter, MqttClientFactory mqttClientFactory, @Named(value="joynr.messaging.channelid") String channelId, MqttTopicPrefixProvider mqttTopicPrefixProvider, RawMessagingPreprocessor rawMessagingPreprocessor, Set<JoynrMessageProcessor> messageProcessors) {
        super(ownAddress, repeatedMqttMessageIgnorePeriodMs, maxIncomingMqttMessagesInQueue, messageRouter, mqttClientFactory, mqttTopicPrefixProvider, rawMessagingPreprocessor, messageProcessors);
        this.replyToAddress = replyToAddress;
        this.channelId = channelId;
    }

    @Override
    protected void subscribe() {
        this.getClient().subscribe("$share:" + this.sanitiseChannelIdForUseAsTopic() + ":" + this.getOwnAddress().getTopic() + "/#");
        this.getClient().subscribe(this.replyToAddress.getTopic() + "/#");
    }

    private String sanitiseChannelIdForUseAsTopic() {
        String result = this.channelId.replaceAll(NON_ALPHA_REGEX_PATTERN, "");
        if (result.isEmpty()) {
            throw new IllegalArgumentException(String.format("The channel ID %s cannot be converted to a valid MQTT topic fragment because it does not contain any alpha characters.", this.channelId));
        }
        return result;
    }
}

