/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.mqtt;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.messaging.FailureAction;
import io.joynr.messaging.JoynrMessageProcessor;
import io.joynr.messaging.RawMessagingPreprocessor;
import io.joynr.messaging.mqtt.IMqttMessagingSkeleton;
import io.joynr.messaging.mqtt.JoynrMqttClient;
import io.joynr.messaging.mqtt.MqttClientFactory;
import io.joynr.messaging.mqtt.MqttTopicPrefixProvider;
import io.joynr.messaging.routing.MessageProcessedListener;
import io.joynr.messaging.routing.MessageRouter;
import io.joynr.messaging.routing.TimedDelayed;
import io.joynr.smrf.EncodingException;
import io.joynr.smrf.UnsuppportedVersionException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.atomic.AtomicInteger;
import joynr.ImmutableMessage;
import joynr.system.RoutingTypes.MqttAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttMessagingSkeleton
implements IMqttMessagingSkeleton,
MessageProcessedListener {
    private static final Logger LOG = LoggerFactory.getLogger(MqttMessagingSkeleton.class);
    private final int repeatedMqttMessageIgnorePeriodMs;
    private final int maxMqttMessagesInQueue;
    private MessageRouter messageRouter;
    private JoynrMqttClient mqttClient;
    private MqttClientFactory mqttClientFactory;
    private MqttAddress ownAddress;
    private ConcurrentMap<String, AtomicInteger> multicastSubscriptionCount = Maps.newConcurrentMap();
    private MqttTopicPrefixProvider mqttTopicPrefixProvider;
    private RawMessagingPreprocessor rawMessagingPreprocessor;
    private Set<JoynrMessageProcessor> messageProcessors;
    private Map<String, MqttAckInformation> processingMessages;
    private DelayQueue<DelayedMessageId> processedMessagesQueue;
    private final boolean backpressureEnabled;

    @Inject
    public MqttMessagingSkeleton(@Named(value="property_mqtt_global_address") MqttAddress ownAddress, @Named(value="joynr.messaging.backpressure.repeatedmqttmessageignoreperiodms") int repeatedMqttMessageIgnorePeriodMs, @Named(value="joynr.messaging.backpressure.maxincomingmqttmessagesinqueue") int maxMqttMessagesInQueue, @Named(value="joynr.messaging.backpressure.enabled") boolean backpressureEnabled, MessageRouter messageRouter, MqttClientFactory mqttClientFactory, MqttTopicPrefixProvider mqttTopicPrefixProvider, RawMessagingPreprocessor rawMessagingPreprocessor, Set<JoynrMessageProcessor> messageProcessors) {
        this.backpressureEnabled = backpressureEnabled;
        this.ownAddress = ownAddress;
        this.repeatedMqttMessageIgnorePeriodMs = repeatedMqttMessageIgnorePeriodMs;
        this.maxMqttMessagesInQueue = maxMqttMessagesInQueue;
        this.messageRouter = messageRouter;
        this.mqttClientFactory = mqttClientFactory;
        this.mqttTopicPrefixProvider = mqttTopicPrefixProvider;
        this.rawMessagingPreprocessor = rawMessagingPreprocessor;
        this.messageProcessors = messageProcessors;
        this.processingMessages = new HashMap<String, MqttAckInformation>();
        this.processedMessagesQueue = new DelayQueue();
    }

    public void init() {
        LOG.debug("Initializing MQTT skeleton ...");
        if (this.backpressureEnabled) {
            this.messageRouter.registerMessageProcessedListener((MessageProcessedListener)this);
        }
        this.mqttClient = this.mqttClientFactory.create();
        this.mqttClient.setMessageListener(this);
        this.mqttClient.start();
        this.subscribe();
    }

    protected void subscribe() {
        this.mqttClient.subscribe(this.ownAddress.getTopic() + "/#");
    }

    public void shutdown() {
        this.mqttClient.shutdown();
    }

    public void registerMulticastSubscription(String multicastId) {
        this.multicastSubscriptionCount.putIfAbsent(multicastId, new AtomicInteger());
        int numberOfSubscriptions = ((AtomicInteger)this.multicastSubscriptionCount.get(multicastId)).incrementAndGet();
        if (numberOfSubscriptions == 1) {
            this.mqttClient.subscribe(this.getSubscriptionTopic(multicastId));
        }
    }

    public void unregisterMulticastSubscription(String multicastId) {
        int remainingCount;
        AtomicInteger subscribersCount = (AtomicInteger)this.multicastSubscriptionCount.get(multicastId);
        if (subscribersCount != null && (remainingCount = subscribersCount.decrementAndGet()) == 0) {
            this.mqttClient.unsubscribe(this.getSubscriptionTopic(multicastId));
        }
    }

    private String translateWildcard(String multicastId) {
        String topic = multicastId;
        if (topic.endsWith("/*")) {
            topic = topic.replaceFirst("/\\*$", "/#");
        }
        return topic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forwardMessageWithBackpressure(ImmutableMessage message, int mqttId, int mqttQos, FailureAction failureAction) {
        message.setReceivedFromGlobal(true);
        Map<String, MqttAckInformation> map = this.processingMessages;
        synchronized (map) {
            this.processingMessages.put(message.getId(), new MqttAckInformation(mqttId, mqttQos));
        }
        try {
            this.messageRouter.route(message);
        }
        catch (Exception e) {
            LOG.error("Error processing incoming message. Message will be dropped: {} ", (Object)e.getMessage());
            Map<String, MqttAckInformation> map2 = this.processingMessages;
            synchronized (map2) {
                this.handleMessageProcessed(message.getId(), mqttId, mqttQos);
            }
            failureAction.execute((Throwable)e);
        }
        map = this.processingMessages;
        synchronized (map) {
            this.removeProcessedMessageInformation();
        }
    }

    private void forwardMessageWithoutBackpressure(ImmutableMessage message, int mqttId, int mqttQos, FailureAction failureAction) {
        message.setReceivedFromGlobal(true);
        try {
            this.messageRouter.route(message);
        }
        catch (Exception e) {
            LOG.error("Error processing incoming message. Message will be dropped: {} ", (Object)e.getMessage());
            failureAction.execute((Throwable)e);
        }
        this.mqttClient.messageReceivedAndProcessingFinished(mqttId, mqttQos);
    }

    @Override
    public void transmit(byte[] serializedMessage, int mqttId, int mqttQos, FailureAction failureAction) {
        try {
            HashMap context = new HashMap();
            byte[] processedMessage = this.rawMessagingPreprocessor.process(serializedMessage, context);
            ImmutableMessage message = new ImmutableMessage(processedMessage);
            message.setContext(context);
            LOG.debug("<<< INCOMING <<< {}", (Object)message);
            if (this.messageProcessors != null) {
                for (JoynrMessageProcessor processor : this.messageProcessors) {
                    message = processor.processIncoming(message);
                }
            }
            if (this.dropMessage(message)) {
                return;
            }
            if (this.backpressureEnabled) {
                this.forwardMessageWithBackpressure(message, mqttId, mqttQos, failureAction);
            } else {
                this.forwardMessageWithoutBackpressure(message, mqttId, mqttQos, failureAction);
            }
        }
        catch (EncodingException | UnsuppportedVersionException | NullPointerException e) {
            LOG.error("Message: \"{}\", could not be deserialized, exception: {}", (Object)serializedMessage, (Object)e.getMessage());
            this.mqttClient.messageReceivedAndProcessingFinished(mqttId, mqttQos);
            failureAction.execute(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dropMessage(ImmutableMessage message) {
        if (this.backpressureEnabled) {
            Map<String, MqttAckInformation> map = this.processingMessages;
            synchronized (map) {
                if (this.processingMessages.size() - this.processedMessagesQueue.size() >= this.maxMqttMessagesInQueue) {
                    LOG.warn("Maximum number of Mqtt messages in message queue reached. Incoming Mqtt message with id {} cannot be handled now.", (Object)message.getId());
                    return true;
                }
                if (this.processingMessages.containsKey(message.getId())) {
                    LOG.debug("Dropping already received message with id {}", (Object)message.getId());
                    return true;
                }
            }
        }
        return false;
    }

    protected JoynrMqttClient getClient() {
        return this.mqttClient;
    }

    protected MqttAddress getOwnAddress() {
        return this.ownAddress;
    }

    private String getSubscriptionTopic(String multicastId) {
        return this.mqttTopicPrefixProvider.getMulticastTopicPrefix() + this.translateWildcard(multicastId);
    }

    private void removeProcessedMessageInformation() {
        DelayedMessageId delayedMessageId;
        while ((delayedMessageId = (DelayedMessageId)((Object)this.processedMessagesQueue.poll())) != null) {
            LOG.debug("Message {} removed from list of processed messages", (Object)delayedMessageId.getMessageId());
            this.processingMessages.remove(delayedMessageId.getMessageId());
        }
    }

    private void handleMessageProcessed(String messageId, int mqttId, int mqttQos) {
        DelayedMessageId delayedMessageId = new DelayedMessageId(messageId, this.repeatedMqttMessageIgnorePeriodMs);
        if (!this.processedMessagesQueue.contains((Object)delayedMessageId)) {
            LOG.debug("Message {} was processed and will be acknowledged", (Object)messageId);
            this.mqttClient.messageReceivedAndProcessingFinished(mqttId, mqttQos);
            this.processedMessagesQueue.put(delayedMessageId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageProcessed(String messageId) {
        Map<String, MqttAckInformation> map = this.processingMessages;
        synchronized (map) {
            MqttAckInformation info = this.processingMessages.get(messageId);
            if (info == null) {
                LOG.debug("Message {} was processed but it is unkown", (Object)messageId);
                return;
            }
            this.handleMessageProcessed(messageId, info.getMqttId(), info.getMqttQos());
            this.removeProcessedMessageInformation();
        }
    }

    private static class DelayedMessageId
    extends TimedDelayed {
        private String messageId;

        public DelayedMessageId(String messageId, long delayMs) {
            super(delayMs);
            this.messageId = messageId;
        }

        public String getMessageId() {
            return this.messageId;
        }

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.messageId == null ? 0 : this.messageId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            DelayedMessageId other = (DelayedMessageId)((Object)obj);
            return !(this.messageId == null ? other.messageId != null : !this.messageId.equals(other.messageId));
        }
    }

    private static class MqttAckInformation {
        private int mqttId;
        private int mqttQos;

        MqttAckInformation(int mqttId, int mqttQos) {
            this.mqttId = mqttId;
            this.mqttQos = mqttQos;
        }

        public int getMqttId() {
            return this.mqttId;
        }

        public int getMqttQos() {
            return this.mqttQos;
        }
    }
}

