/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.mqtt.paho.client;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.joynr.exceptions.JoynrIllegalStateException;
import io.joynr.messaging.mqtt.JoynrMqttClient;
import io.joynr.messaging.mqtt.MqttClientFactory;
import io.joynr.messaging.mqtt.MqttClientIdProvider;
import io.joynr.messaging.mqtt.paho.client.MqttPahoClient;
import io.joynr.messaging.mqtt.statusmetrics.MqttStatusReceiver;
import io.joynr.runtime.ShutdownListener;
import io.joynr.runtime.ShutdownNotifier;
import java.util.HashMap;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MqttPahoClientFactory
implements MqttClientFactory,
ShutdownListener {
    private static final Logger logger = LoggerFactory.getLogger(MqttPahoClientFactory.class);
    private HashMap<String, JoynrMqttClient> receivingMqttClients;
    private HashMap<String, JoynrMqttClient> sendingMqttClients;
    private int reconnectSleepMs;
    private HashMap<String, String> mqttGbidToBrokerUriMap;
    private HashMap<String, Integer> mqttGbidToKeepAliveTimerSecMap;
    private HashMap<String, Integer> mqttGbidToConnectionTimeoutSecMap;
    private int timeToWaitMs;
    private int maxMsgsInflight;
    private int maxMsgSizeBytes;
    private boolean cleanSession;
    private boolean separateConnections;
    private ScheduledExecutorService scheduledExecutorService;
    private MqttClientIdProvider clientIdProvider;
    private MqttStatusReceiver mqttStatusReceiver;
    @Inject(optional=true)
    @Named(value="joynr.messaging.mqtt.ssl.keystore")
    private String keyStorePath = "";
    @Inject(optional=true)
    @Named(value="joynr.messaging.mqtt.ssl.truststore")
    private String trustStorePath = "";
    @Inject(optional=true)
    @Named(value="joynr.messaging.mqtt.ssl.keystoretype")
    private String keyStoreType = "JKS";
    @Inject(optional=true)
    @Named(value="joynr.messaging.mqtt.ssl.truststoretype")
    private String trustStoreType = "JKS";
    @Inject(optional=true)
    @Named(value="joynr.messaging.mqtt.ssl.keystorepassword")
    private String keyStorePWD = "";
    @Inject(optional=true)
    @Named(value="joynr.messaging.mqtt.ssl.truststorepassword")
    private String trustStorePWD = "";
    @Inject(optional=true)
    @Named(value="joynr.messaging.mqtt.username")
    private String username = "";
    @Inject(optional=true)
    @Named(value="joynr.messaging.mqtt.password")
    private String password = "";

    @Inject
    public MqttPahoClientFactory(@Named(value="joynr.messaging.mqtt.reconnect.sleepms") int reconnectSleepMs, @Named(value="joynr.internal.messaging.mqtt.gbidtobrokerurimap") HashMap<String, String> mqttGbidToBrokerUriMap, @Named(value="joynr.internal.messaging.mqtt.gbidtokeepalivetimersecmap") HashMap<String, Integer> mqttGbidToKeepAliveTimerSecMap, @Named(value="joynr.internal.messaging.mqtt.gbidtoconnectiontimeoutsecmap") HashMap<String, Integer> mqttGbidToConnectionTimeoutSecMap, @Named(value="joynr.messaging.mqtt.timetowaitms") int timeToWaitMs, @Named(value="joynr.messaging.mqtt.maxmsgsinflight") int maxMsgsInflight, @Named(value="joynr.messaging.mqtt.maxmqttmessagesizebytes") int maxMsgSizeBytes, @Named(value="joynr.messaging.mqtt.cleansession") boolean cleanSession, @Named(value="joynr.messaging.mqtt.separateconnections") boolean separateConnections, @Named(value="io.joynr.messaging.scheduledthreadpool") ScheduledExecutorService scheduledExecutorService, MqttClientIdProvider mqttClientIdProvider, MqttStatusReceiver mqttStatusReceiver, ShutdownNotifier shutdownNotifier) {
        this.reconnectSleepMs = reconnectSleepMs;
        this.mqttGbidToBrokerUriMap = mqttGbidToBrokerUriMap;
        this.mqttGbidToKeepAliveTimerSecMap = mqttGbidToKeepAliveTimerSecMap;
        this.mqttGbidToConnectionTimeoutSecMap = mqttGbidToConnectionTimeoutSecMap;
        this.timeToWaitMs = timeToWaitMs;
        this.maxMsgsInflight = maxMsgsInflight;
        this.maxMsgSizeBytes = maxMsgSizeBytes;
        this.cleanSession = cleanSession;
        this.separateConnections = separateConnections;
        this.scheduledExecutorService = scheduledExecutorService;
        this.clientIdProvider = mqttClientIdProvider;
        this.mqttStatusReceiver = mqttStatusReceiver;
        shutdownNotifier.registerForShutdown((ShutdownListener)this);
        this.sendingMqttClients = new HashMap();
        this.receivingMqttClients = new HashMap();
    }

    @Override
    public synchronized JoynrMqttClient createReceiver(String gbid) {
        if (!this.receivingMqttClients.containsKey(gbid)) {
            if (this.separateConnections) {
                this.receivingMqttClients.put(gbid, this.createInternal(gbid, true, "Sub"));
            } else {
                this.createCombinedClient(gbid);
            }
        }
        return this.receivingMqttClients.get(gbid);
    }

    @Override
    public synchronized JoynrMqttClient createSender(String gbid) {
        if (!this.sendingMqttClients.containsKey(gbid)) {
            if (this.separateConnections) {
                this.sendingMqttClients.put(gbid, this.createInternal(gbid, false, "Pub"));
            } else {
                this.createCombinedClient(gbid);
            }
        }
        return this.sendingMqttClients.get(gbid);
    }

    public synchronized void prepareForShutdown() {
        if (this.separateConnections) {
            for (JoynrMqttClient client : this.receivingMqttClients.values()) {
                client.shutdown();
            }
        }
    }

    public synchronized void shutdown() {
        for (JoynrMqttClient client : this.sendingMqttClients.values()) {
            client.shutdown();
        }
        if (this.separateConnections) {
            for (JoynrMqttClient client : this.receivingMqttClients.values()) {
                if (client.isShutdown()) continue;
                client.shutdown();
            }
        }
    }

    private void createCombinedClient(String gbid) {
        this.sendingMqttClients.put(gbid, this.createInternal(gbid, true, ""));
        this.receivingMqttClients.put(gbid, this.sendingMqttClients.get(gbid));
    }

    private JoynrMqttClient createInternal(String gbid, boolean isReceiver, String clientIdSuffix) {
        String brokerUri = this.mqttGbidToBrokerUriMap.get(gbid);
        if (brokerUri == null) {
            throw new JoynrIllegalStateException("BrokerUri for GBID \"" + gbid + "\" is missing.");
        }
        MqttPahoClient pahoClient = null;
        try {
            String clientId = this.clientIdProvider.getClientId() + clientIdSuffix;
            logger.info("Creating MQTT Paho client using MQTT client ID: {}", (Object)clientId);
            pahoClient = new MqttPahoClient(brokerUri, clientId, this.scheduledExecutorService, this.reconnectSleepMs, this.mqttGbidToKeepAliveTimerSecMap.get(gbid), this.mqttGbidToConnectionTimeoutSecMap.get(gbid), this.timeToWaitMs, this.maxMsgsInflight, this.maxMsgSizeBytes, this.cleanSession, isReceiver, this.separateConnections, this.keyStorePath, this.trustStorePath, this.keyStoreType, this.trustStoreType, this.keyStorePWD, this.trustStorePWD, this.username, this.password, this.mqttStatusReceiver);
        }
        catch (MqttException e) {
            logger.error("Create MqttClient failed", (Throwable)e);
        }
        return pahoClient;
    }
}

