/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.mqtt;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.messaging.AbstractMiddlewareMessagingStubFactory;
import io.joynr.messaging.mqtt.JoynrMqttClient;
import io.joynr.messaging.mqtt.MqttClientFactory;
import io.joynr.messaging.mqtt.MqttMessagingStub;
import java.util.HashMap;
import java.util.Map;
import joynr.system.RoutingTypes.MqttAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttMessagingStubFactory
extends AbstractMiddlewareMessagingStubFactory<MqttMessagingStub, MqttAddress> {
    private static final Logger logger = LoggerFactory.getLogger(MqttMessagingStubFactory.class);
    private Map<String, JoynrMqttClient> gbidToMqttClientMap = new HashMap<String, JoynrMqttClient>();

    @Inject
    public MqttMessagingStubFactory(MqttClientFactory mqttClientFactory, @Named(value="joynr.internal.messaging.gbidArray") String[] gbid_array) {
        for (String gbid : gbid_array) {
            this.gbidToMqttClientMap.put(gbid, mqttClientFactory.createSender(gbid));
        }
    }

    protected MqttMessagingStub createInternal(MqttAddress address) {
        String gbid = address.getBrokerUri();
        if (!this.gbidToMqttClientMap.containsKey(gbid)) {
            logger.error("Gbid {} is not known in MqttMessagingStubFactory.", (Object)gbid);
            return null;
        }
        return new MqttMessagingStub(address, this.gbidToMqttClientMap.get(gbid));
    }
}

