/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.mqtt;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.messaging.mqtt.MqttTopicPrefixProvider;
import io.joynr.messaging.routing.MulticastAddressCalculator;
import java.util.HashSet;
import java.util.Set;
import joynr.ImmutableMessage;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.MqttAddress;

public class MqttMulticastAddressCalculator
implements MulticastAddressCalculator {
    private MqttTopicPrefixProvider mqttTopicPrefixProvider;
    private final String[] gbidArray;

    @Inject
    public MqttMulticastAddressCalculator(@Named(value="joynr.internal.messaging.gbidArray") String[] gbidArray, MqttTopicPrefixProvider mqttTopicPrefixProvider) {
        this.gbidArray = (String[])gbidArray.clone();
        this.mqttTopicPrefixProvider = mqttTopicPrefixProvider;
    }

    public Set<Address> calculate(ImmutableMessage message) {
        HashSet<Address> result = new HashSet<Address>();
        String topic = this.mqttTopicPrefixProvider.getMulticastTopicPrefix() + message.getRecipient();
        for (String gbid : this.gbidArray) {
            result.add((Address)new MqttAddress(gbid, topic));
        }
        return result;
    }

    public boolean supports(String transport) {
        return "mqtt".equalsIgnoreCase(transport);
    }

    public boolean createsGlobalTransportAddresses() {
        return true;
    }
}

