/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.mqtt;

import io.joynr.common.ExpiryDate;
import io.joynr.messaging.FailureAction;
import io.joynr.messaging.IMessagingStub;
import io.joynr.messaging.MessagingQosEffort;
import io.joynr.messaging.SuccessAction;
import io.joynr.messaging.mqtt.JoynrMqttClient;
import joynr.ImmutableMessage;
import joynr.Message;
import joynr.system.RoutingTypes.MqttAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttMessagingStub
implements IMessagingStub {
    private static final Logger logger = LoggerFactory.getLogger(MqttMessagingStub.class);
    public static final int DEFAULT_QOS_LEVEL = 1;
    public static final int BEST_EFFORT_QOS_LEVEL = 0;
    private static final String PRIORITY_LOW = "/low";
    private static final long MESSAGE_EXPIRY_MAX_INTERVAL = 0xFFFFFFFFL;
    private MqttAddress address;
    private JoynrMqttClient mqttClient;

    public MqttMessagingStub(MqttAddress address, JoynrMqttClient mqttClient) {
        this.address = address;
        this.mqttClient = mqttClient;
    }

    public void transmit(ImmutableMessage message, SuccessAction successAction, FailureAction failureAction) {
        ExpiryDate expiryDate;
        long msgTtlSec;
        String topic = this.address.getTopic();
        if (!Message.MessageType.VALUE_MESSAGE_TYPE_MULTICAST.equals((Object)message.getType())) {
            topic = topic + PRIORITY_LOW;
        }
        int qosLevel = 1;
        String effortHeaderValue = message.getEffort();
        if (effortHeaderValue != null && String.valueOf(MessagingQosEffort.BEST_EFFORT).equals(effortHeaderValue)) {
            qosLevel = 0;
        }
        if ((msgTtlSec = (long)Math.ceil((double)(expiryDate = ExpiryDate.fromAbsolute((long)message.getTtlMs())).getRelativeTtl() / 1000.0)) > 0xFFFFFFFFL || msgTtlSec < 0L) {
            msgTtlSec = 0xFFFFFFFFL;
        }
        byte[] serializedMessage = message.getSerializedMessage();
        if (logger.isTraceEnabled()) {
            logger.trace(">>> OUTGOING TO {} >>> {}", (Object)this.address.getBrokerUri(), (Object)message);
        } else {
            logger.debug(">>> OUTGOING TO {} >>> {}", (Object)this.address.getBrokerUri(), (Object)message.getTrackingInfo());
        }
        this.mqttClient.publishMessage(topic, serializedMessage, message.getPrefixedCustomHeaders(), qosLevel, msgTtlSec, successAction, failureAction);
    }
}

