/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.mqtt;

import com.google.inject.Inject;
import io.joynr.exceptions.JoynrIllegalStateException;
import java.util.Arrays;
import java.util.HashMap;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttMultipleBackendPropertyProvider {
    private static final Logger logger = LoggerFactory.getLogger(MqttMultipleBackendPropertyProvider.class);
    private String[] brokerUriArray;
    private final HashMap<String, String> gbidToBrokerUriMap;
    private final HashMap<String, Integer> gbidToKeepAliveTimerSecMap;
    private final HashMap<String, Integer> gbidToConnectionTimeoutSecMap;

    @Inject
    public MqttMultipleBackendPropertyProvider(@Named(value="joynr.messaging.mqtt.brokeruris") String brokerUris, @Named(value="joynr.messaging.gbids") String gbids, @Named(value="joynr.messaging.mqtt.keepalivetimerssec") String keepAliveTimersSec, @Named(value="joynr.messaging.mqtt.connectiontimeoutssec") String connectionTimeoutsSec) {
        Integer[] connectionTimeoutTimerSecArray;
        Integer[] keepAliveTimerSecArray;
        String[] gbidArray = (String[])Arrays.stream(gbids.split(",")).map(a -> a.trim()).toArray(String[]::new);
        this.brokerUriArray = (String[])Arrays.stream(brokerUris.split(",")).map(a -> a.trim()).toArray(String[]::new);
        if (this.brokerUriArray.length != gbidArray.length) {
            logger.error("The amount of defined BrokerUris is not equal to the amount of defined GBIDs!");
            throw new JoynrIllegalStateException("The amount of defined BrokerUris is not equal to the amount of defined GBIDs!");
        }
        if (Arrays.stream(this.brokerUriArray).anyMatch(brokerUri -> brokerUri.isEmpty())) {
            logger.error("BrokerUri must not be empty: {}!", (Object)brokerUris);
            throw new JoynrIllegalStateException("BrokerUri must not be empty: " + brokerUris + "!");
        }
        try {
            keepAliveTimerSecArray = MqttMultipleBackendPropertyProvider.stringArrayToIntArray(keepAliveTimersSec.replaceAll("\\s", "").split(","));
        }
        catch (NumberFormatException e) {
            logger.error("Invalid entry in: {}!", (Object)"joynr.messaging.mqtt.keepalivetimerssec");
            throw new JoynrIllegalStateException("Invalid entry in joynr.messaging.mqtt.keepalivetimerssec!");
        }
        if (keepAliveTimerSecArray.length != gbidArray.length) {
            logger.error("The amount of defined MQTT keep alive times is not equal to the amount of defined GBIDs!");
            throw new JoynrIllegalStateException("The amount of defined MQTT keep alive times is not equal to the amount of defined GBIDs!");
        }
        try {
            connectionTimeoutTimerSecArray = MqttMultipleBackendPropertyProvider.stringArrayToIntArray(connectionTimeoutsSec.replaceAll("\\s", "").split(","));
        }
        catch (NumberFormatException e) {
            logger.error("Invalid entry in: {}!", (Object)"joynr.messaging.mqtt.connectiontimeoutssec");
            throw new JoynrIllegalStateException("Invalid entry in joynr.messaging.mqtt.connectiontimeoutssec!");
        }
        if (connectionTimeoutTimerSecArray.length != gbidArray.length) {
            logger.error("The amount of defined MQTT connection timeout times is not equal to the amount of defined GBIDs!");
            throw new JoynrIllegalStateException("The amount of defined MQTT connection timeout times is not equal to the amount of defined GBIDs!");
        }
        this.gbidToBrokerUriMap = MqttMultipleBackendPropertyProvider.arraysToHashMap(gbidArray, this.brokerUriArray);
        this.gbidToConnectionTimeoutSecMap = MqttMultipleBackendPropertyProvider.arraysToHashMap(gbidArray, connectionTimeoutTimerSecArray);
        this.gbidToKeepAliveTimerSecMap = MqttMultipleBackendPropertyProvider.arraysToHashMap(gbidArray, connectionTimeoutTimerSecArray);
    }

    private static Integer[] stringArrayToIntArray(String[] stringArray) {
        Integer[] intArray = new Integer[stringArray.length];
        for (int i = 0; i < intArray.length; ++i) {
            intArray[i] = Integer.parseInt(stringArray[i]);
        }
        return intArray;
    }

    private static <T> HashMap<String, T> arraysToHashMap(String[] keyArray, T[] valueArray) {
        HashMap<String, T> hashMap = new HashMap<String, T>();
        for (int i = 0; i < keyArray.length; ++i) {
            hashMap.put(keyArray[i], valueArray[i]);
        }
        return hashMap;
    }

    public String[] provideBrokerUris() {
        return (String[])this.brokerUriArray.clone();
    }

    public HashMap<String, String> provideGbidToBrokerUriMap() {
        return this.gbidToBrokerUriMap;
    }

    public final HashMap<String, Integer> provideGbidToKeepAliveTimerSecMap() {
        return this.gbidToKeepAliveTimerSecMap;
    }

    public final HashMap<String, Integer> provideGbidToConnectionTimeoutSecMap() {
        return this.gbidToConnectionTimeoutSecMap;
    }
}

